
/* ------- code automatically created by ./mkelements.pl -------------- */

#ifndef adms_h
#define adms_h

/* Define to the full name of this package. */
#define PACKAGE_NAME "adms"

/* Define to the version of this package. */
#define PACKAGE_VERSION "2.3.4-qs"

// headers -- depend on compiler, OS, ...
#  if defined(_MSC_VER)
#    include <io.h>
#    include <direct.h>
#    define isnan _isnan
#    define ADMS_PATH_SEPARATOR "/"
#    define ADMS_F_OK 0
#    ifndef inline
#      define inline
#    endif
#    define YY_NO_UNISTD_H
#  else
#    include <unistd.h>
#    define ADMS_PATH_SEPARATOR "/"
#    define ADMS_F_OK F_OK
#  endif
#  include <math.h>
#  include <sys/stat.h>
#  include <locale.h>
#  include <float.h>
#  include <stdlib.h>
#  include <string.h>
#  include <assert.h>
#  include <signal.h>
#  include <stdarg.h>
#  include <stdio.h>
#  include <ctype.h>
#  include <errno.h>
#  include <time.h>
/* in case not Posix */
#  if defined(_S_IFDIR)
#    define ADMS_S_IFDIR _S_IFDIR
#  else
#    define ADMS_S_IFDIR S_IFDIR
#  endif
/* check OS */
#  if defined(__CYGWIN__)
#    define ADMS_OS_MS
#    define ADMS_OS_MSCYGWIN
#    define ADMS_OS "MSCYGWIN"
#  elif defined(_WIN64)
#    define ADMS_OS_MS
#    define ADMS_OS_MSWIN64
#    define ADMS_OS "MSWIN64"
#  elif defined(_WIN32)
#    define ADMS_OS_MS
#    define ADMS_OS_MSWIN32
#    define ADMS_OS "MSWIN32"
#  elif defined(__APPLE__)
#    define ADMS_OS_DARWIN
#    define ADMS_OS "DARWIN"
#  elif defined(__linux)
#    define ADMS_OS_LINUX
#    define ADMS_OS "LINUX"
#  else
#    define ADMS_OS_UNKNOWN
#    define ADMS_OS "UNKNOWN"
#  endif
/* check compiler */
#  if defined(__MINGW32__)
#    ifndef WIN32
#      define WIN32
#    endif
#    define ADMS_COMPILER_MINGW32
#    define ADMS_COMPILER "MINGW32"
#  elif defined(__CYGWIN__)
#    ifndef WIN32
#      define WIN32
#    endif
#    define ADMS_COMPILER_GCC
#    define ADMS_COMPILER "GCC"
#  elif defined(_MSC_VER)
#    ifndef WIN32
#      define WIN32
#    endif
#    define ADMS_COMPILER_MSVC
#    define ADMS_COMPILER "MSVC"
#  elif defined(__APPLE__)
#    if defined(__clang__)
#      define ADMS_COMPILER_CLANG
#      define ADMS_COMPILER "CLANG"
#    elif defined(__GNUC__)
#      define ADMS_COMPILER_GCC
#      define ADMS_COMPILER "GCC"
#    endif
#  elif defined(__linux)
#    if defined(__GNUC__)
#      define ADMS_COMPILER_GCC
#      define ADMS_COMPILER "GCC"
#    endif
#  else
#    define ADMS_COMPILER_CC
#    define ADMS_COMPILER "CC"
#  endif

#define TK\
  TTK(adms)\
  TTK(simulator)\
  TTK(admsmain)\
  TTK(list)\
  TTK(nature)\
  TTK(discipline)\
  TTK(module)\
  TTK(analogfunction)\
  TTK(nodealias)\
  TTK(node)\
  TTK(branchalias)\
  TTK(branch)\
  TTK(variableprototype)\
  TTK(source)\
  TTK(range)\
  TTK(jacobian)\
  TTK(analog)\
  TTK(math)\
  TTK(string)\
  TTK(subexpression)\
  TTK(mapply_unary)\
  TTK(mapply_binary)\
  TTK(mapply_ternary)\
  TTK(number)\
  TTK(function)\
  TTK(variable)\
  TTK(array)\
  TTK(probe)\
  TTK(expression)\
  TTK(instance)\
  TTK(instanceparameter)\
  TTK(instancenode)\
  TTK(nilled)\
  TTK(assignment)\
  TTK(contribution)\
  TTK(conditional)\
  TTK(forloop)\
  TTK(whileloop)\
  TTK(case)\
  TTK(caseitem)\
  TTK(blockvariable)\
  TTK(block)\
  TTK(callfunction)\
  TTK(evaluation)\
  TTK(text)\
  TTK(path)\
  TTK(ptraverse)\
  TTK(pparse)\
  TTK(admst)\
  TTK(transform)\
  TTK(itransform)\
  TTK(return)\
  TTK(attribute)\
  TTK(admstvariable)\
  TTK(lexval)\
  TTK(yaccval)\
  TTK(datatypename)\
  TTK(name)\
  TTK(currentdate)\
  TTK(developer)\
  TTK(fullname)\
  TTK(package_name)\
  TTK(package_tarname)\
  TTK(package_version)\
  TTK(package_string)\
  TTK(package_bugreport)\
  TTK(tmp)\
  TTK(tmp1)\
  TTK(br1)\
  TTK(br2)\
  TTK(sr1)\
  TTK(ddx)\
  TTK(argc)\
  TTK(fullfilename)\
  TTK(filename)\
  TTK(curfilename)\
  TTK(curline)\
  TTK(fpos)\
  TTK(info)\
  TTK(usage)\
  TTK(verbose)\
  TTK(hint)\
  TTK(warning)\
  TTK(obsolete)\
  TTK(debug)\
  TTK(dbg_vla)\
  TTK(dbg_xml)\
  TTK(error)\
  TTK(fatal)\
  TTK(dbg_mem)\
  TTK(argv)\
  TTK(invtransform)\
  TTK(itransforminsideapplytemplate)\
  TTK(valueof)\
  TTK(datatype)\
  TTK(item)\
  TTK(access)\
  TTK(abstol)\
  TTK(base)\
  TTK(ddt_name)\
  TTK(ddt_nature)\
  TTK(idt_name)\
  TTK(idt_nature)\
  TTK(units)\
  TTK(flow)\
  TTK(potential)\
  TTK(domain)\
  TTK(instantiator)\
  TTK(type)\
  TTK(tree)\
  TTK(direction)\
  TTK(grounded)\
  TTK(location)\
  TTK(pnode)\
  TTK(nnode)\
  TTK(dependency)\
  TTK(static)\
  TTK(dynamic)\
  TTK(sizetype)\
  TTK(parametertype)\
  TTK(maxsize)\
  TTK(minsize)\
  TTK(input)\
  TTK(output)\
  TTK(scope)\
  TTK(default)\
  TTK(derivate)\
  TTK(isstate)\
  TTK(usedinmodel)\
  TTK(usedininstance)\
  TTK(usedininitial_step)\
  TTK(usedinevaluate)\
  TTK(usedinnoise)\
  TTK(usedinfinal)\
  TTK(setinmodel)\
  TTK(setininstance)\
  TTK(setininitial_step)\
  TTK(setinevaluate)\
  TTK(setinnoise)\
  TTK(setinfinal)\
  TTK(setingetprev)\
  TTK(TemperatureDependent)\
  TTK(OPdependent)\
  TTK(insource)\
  TTK(vcount)\
  TTK(vlast)\
  TTK(arraydefault)\
  TTK(alias)\
  TTK(ddxprobe)\
  TTK(whitenoise)\
  TTK(flickernoise)\
  TTK(switch)\
  TTK(infexpr)\
  TTK(supexpr)\
  TTK(infboundtype)\
  TTK(supboundtype)\
  TTK(row)\
  TTK(column)\
  TTK(diagonal)\
  TTK(code)\
  TTK(value)\
  TTK(arg1)\
  TTK(arg2)\
  TTK(arg3)\
  TTK(scalingunit)\
  TTK(cast)\
  TTK(unique_id)\
  TTK(definition)\
  TTK(class)\
  TTK(arguments)\
  TTK(prototype)\
  TTK(index)\
  TTK(seen)\
  TTK(hasspecialnumber)\
  TTK(hasVoltageDependentFunction)\
  TTK(infinity)\
  TTK(terminal)\
  TTK(parameterset)\
  TTK(parameter)\
  TTK(nodefrominstantiator)\
  TTK(nodefrommodule)\
  TTK(lhs)\
  TTK(rhs)\
  TTK(if)\
  TTK(then)\
  TTK(else)\
  TTK(initial)\
  TTK(condition)\
  TTK(update)\
  TTK(forblock)\
  TTK(while)\
  TTK(whileblock)\
  TTK(defaultcase)\
  TTK(aname)\
  TTK(admse)\
  TTK(token)\
  TTK(avalue)\
  TTK(template)\
  TTK(keeplist)\
  TTK(callbackname)\
  TTK(callback)\
  TTK(bar)\
  TTK(arg)\
  TTK(u)\
  TTK(b)\
  TTK(c)\
  TTK(alladmst)\
  TTK(aliasadmst)\
  TTK(position)\
  TTK(a1)\
  TTK(an)\
  TTK(tkstart)\
  TTK(tklen)\
  TTK(tkid)\
  TTK(previous)\
  TTK(previouspath)\
  TTK(pseudo)\
  TTK(valueto)\
  TTK(count)\
  TTK(hasnewbasicstring)\
  TTK(original)\
  TTK(refd)\
  TTK(true)\
  TTK(preva)\
  TTK(nexta)\
  TTK(selected)\
  TTK(basefilename)\
  TTK(l)\
  TTK(parent)\
  TTK(id)\
  TTK(pathselect)\
  TTK(pathpath)\
  TTK(pathinto)\
  TTK(pathtest)\
  TTK(pathlist)\
  TTK(textselect)\
  TTK(textdatatype)\
  TTK(textmatch)\
  TTK(textrequired)\
  TTK(textseparator)\
  TTK(textfrom)\
  TTK(textto)\
  TTK(textlist)\
  TTK(textname)\
  TTK(textformat)\
  TTK(textfile)\
  TTK(textversion)\
  TTK(textonduplicate)\
  TTK(textprobe)\
  TTK(textstring)\
  TTK(templates)\
  TTK(textarguments)\
  TTK(pathoncompare)\
  TTK(pathinputs)\
  TTK(children)\
  TTK(originalcall)\
  TTK(f)\
  TTK(usrdata)\
  TTK(yes)\
  TTK(no)\
  TTK(continuous)\
  TTK(discrete)\
  TTK(real)\
  TTK(integer)\
  TTK(inout)\
  TTK(internal)\
  TTK(ground)\
  TTK(external)\
  TTK(constant)\
  TTK(noprobe)\
  TTK(linear)\
  TTK(nonlinear)\
  TTK(scalar)\
  TTK(model)\
  TTK(local)\
  TTK(global_model)\
  TTK(global_instance)\
  TTK(global_final)\
  TTK(global_past)\
  TTK(shot)\
  TTK(thermal)\
  TTK(flicker)\
  TTK(fs)\
  TTK(ps)\
  TTK(range_bound_include)\
  TTK(range_bound_exclude)\
  TTK(range_bound_value)\
  TTK(include)\
  TTK(include_value)\
  TTK(exclude)\
  TTK(exclude_value)\
  TTK(plus)\
  TTK(minus)\
  TTK(not)\
  TTK(bw_not)\
  TTK(bw_equr)\
  TTK(bw_equl)\
  TTK(bw_xor)\
  TTK(bw_or)\
  TTK(bw_and)\
  TTK(or)\
  TTK(and)\
  TTK(equ)\
  TTK(notequ)\
  TTK(lt)\
  TTK(lt_equ)\
  TTK(gt)\
  TTK(gt_equ)\
  TTK(shiftr)\
  TTK(shiftl)\
  TTK(addp)\
  TTK(addm)\
  TTK(multtime)\
  TTK(multdiv)\
  TTK(multmod)\
  TTK(E)\
  TTK(P)\
  TTK(T)\
  TTK(G)\
  TTK(M)\
  TTK(k)\
  TTK(h)\
  TTK(D)\
  TTK(1)\
  TTK(d)\
  TTK(m)\
  TTK(n)\
  TTK(A)\
  TTK(p)\
  TTK(a)\
  TTK(i)\
  TTK(builtin)\
  TTK(digital)\
  TTK(is_zero)\
  TTK(is_one)\
  TTK(is_neg_one)\
  TTK(is_any)\
  TTK(past_name)\
  TTK(datatypefamily)\
  TTK(absolute)\
  TTK(basicenumeration)\
  TTK(basicinteger)\
  TTK(basicreal)\
  TTK(basicstring)\
  TTK(basiclist)\
  TTK(empty)\
/*fin*/


#undef TTK
#define TTK(tk) admse_##tk,
typedef enum {
  admse__zero=0,
  admse__any,
  admse__constant,
  admse__p, /*%p*/
  admse__s, /*%s*/
  admse__path,
  admse__arguments,
  admse__croix,
  admse__croixcroix,
  admse__ladms,
  admse__ladmst,
  TK
  admse__
} admse;

typedef struct s_adms  t_adms;
typedef t_adms*        p_adms;
typedef const p_adms   p_kadms;
typedef struct s_simulator  t_simulator;
typedef t_simulator*        p_simulator;
typedef const p_simulator   p_ksimulator;
typedef struct s_admsmain  t_admsmain;
typedef t_admsmain*        p_admsmain;
typedef const p_admsmain   p_kadmsmain;
typedef struct s_list  t_list;
typedef t_list*        p_list;
typedef const p_list   p_klist;
typedef struct s_nature  t_nature;
typedef t_nature*        p_nature;
typedef const p_nature   p_knature;
typedef struct s_discipline  t_discipline;
typedef t_discipline*        p_discipline;
typedef const p_discipline   p_kdiscipline;
typedef struct s_module  t_module;
typedef t_module*        p_module;
typedef const p_module   p_kmodule;
typedef struct s_analogfunction  t_analogfunction;
typedef t_analogfunction*        p_analogfunction;
typedef const p_analogfunction   p_kanalogfunction;
typedef struct s_nodealias  t_nodealias;
typedef t_nodealias*        p_nodealias;
typedef const p_nodealias   p_knodealias;
typedef struct s_node  t_node;
typedef t_node*        p_node;
typedef const p_node   p_knode;
typedef struct s_branchalias  t_branchalias;
typedef t_branchalias*        p_branchalias;
typedef const p_branchalias   p_kbranchalias;
typedef struct s_branch  t_branch;
typedef t_branch*        p_branch;
typedef const p_branch   p_kbranch;
typedef struct s_variableprototype  t_variableprototype;
typedef t_variableprototype*        p_variableprototype;
typedef const p_variableprototype   p_kvariableprototype;
typedef struct s_source  t_source;
typedef t_source*        p_source;
typedef const p_source   p_ksource;
typedef struct s_range  t_range;
typedef t_range*        p_range;
typedef const p_range   p_krange;
typedef struct s_jacobian  t_jacobian;
typedef t_jacobian*        p_jacobian;
typedef const p_jacobian   p_kjacobian;
typedef struct s_analog  t_analog;
typedef t_analog*        p_analog;
typedef const p_analog   p_kanalog;
typedef struct s_math  t_math;
typedef t_math*        p_math;
typedef const p_math   p_kmath;
typedef struct s_string  t_string;
typedef t_string*        p_string;
typedef const p_string   p_kstring;
typedef struct s_subexpression  t_subexpression;
typedef t_subexpression*        p_subexpression;
typedef const p_subexpression   p_ksubexpression;
typedef struct s_mapply_unary  t_mapply_unary;
typedef t_mapply_unary*        p_mapply_unary;
typedef const p_mapply_unary   p_kmapply_unary;
typedef struct s_mapply_binary  t_mapply_binary;
typedef t_mapply_binary*        p_mapply_binary;
typedef const p_mapply_binary   p_kmapply_binary;
typedef struct s_mapply_ternary  t_mapply_ternary;
typedef t_mapply_ternary*        p_mapply_ternary;
typedef const p_mapply_ternary   p_kmapply_ternary;
typedef struct s_number  t_number;
typedef t_number*        p_number;
typedef const p_number   p_knumber;
typedef struct s_function  t_function;
typedef t_function*        p_function;
typedef const p_function   p_kfunction;
typedef struct s_variable  t_variable;
typedef t_variable*        p_variable;
typedef const p_variable   p_kvariable;
typedef struct s_array  t_array;
typedef t_array*        p_array;
typedef const p_array   p_karray;
typedef struct s_probe  t_probe;
typedef t_probe*        p_probe;
typedef const p_probe   p_kprobe;
typedef struct s_expression  t_expression;
typedef t_expression*        p_expression;
typedef const p_expression   p_kexpression;
typedef struct s_instance  t_instance;
typedef t_instance*        p_instance;
typedef const p_instance   p_kinstance;
typedef struct s_instanceparameter  t_instanceparameter;
typedef t_instanceparameter*        p_instanceparameter;
typedef const p_instanceparameter   p_kinstanceparameter;
typedef struct s_instancenode  t_instancenode;
typedef t_instancenode*        p_instancenode;
typedef const p_instancenode   p_kinstancenode;
typedef struct s_nilled  t_nilled;
typedef t_nilled*        p_nilled;
typedef const p_nilled   p_knilled;
typedef struct s_assignment  t_assignment;
typedef t_assignment*        p_assignment;
typedef const p_assignment   p_kassignment;
typedef struct s_contribution  t_contribution;
typedef t_contribution*        p_contribution;
typedef const p_contribution   p_kcontribution;
typedef struct s_conditional  t_conditional;
typedef t_conditional*        p_conditional;
typedef const p_conditional   p_kconditional;
typedef struct s_forloop  t_forloop;
typedef t_forloop*        p_forloop;
typedef const p_forloop   p_kforloop;
typedef struct s_whileloop  t_whileloop;
typedef t_whileloop*        p_whileloop;
typedef const p_whileloop   p_kwhileloop;
typedef struct s_case  t_case;
typedef t_case*        p_case;
typedef const p_case   p_kcase;
typedef struct s_caseitem  t_caseitem;
typedef t_caseitem*        p_caseitem;
typedef const p_caseitem   p_kcaseitem;
typedef struct s_blockvariable  t_blockvariable;
typedef t_blockvariable*        p_blockvariable;
typedef const p_blockvariable   p_kblockvariable;
typedef struct s_block  t_block;
typedef t_block*        p_block;
typedef const p_block   p_kblock;
typedef struct s_callfunction  t_callfunction;
typedef t_callfunction*        p_callfunction;
typedef const p_callfunction   p_kcallfunction;
typedef struct s_evaluation  t_evaluation;
typedef t_evaluation*        p_evaluation;
typedef const p_evaluation   p_kevaluation;
typedef struct s_text  t_text;
typedef t_text*        p_text;
typedef const p_text   p_ktext;
typedef struct s_path  t_path;
typedef t_path*        p_path;
typedef const p_path   p_kpath;
typedef struct s_ptraverse  t_ptraverse;
typedef t_ptraverse*        p_ptraverse;
typedef const p_ptraverse   p_kptraverse;
typedef struct s_pparse  t_pparse;
typedef t_pparse*        p_pparse;
typedef const p_pparse   p_kpparse;
typedef struct s_admst  t_admst;
typedef t_admst*        p_admst;
typedef const p_admst   p_kadmst;
typedef struct s_transform  t_transform;
typedef t_transform*        p_transform;
typedef const p_transform   p_ktransform;
typedef struct s_itransform  t_itransform;
typedef t_itransform*        p_itransform;
typedef const p_itransform   p_kitransform;
typedef struct s_return  t_return;
typedef t_return*        p_return;
typedef const p_return   p_kreturn;
typedef struct s_attribute  t_attribute;
typedef t_attribute*        p_attribute;
typedef const p_attribute   p_kattribute;
typedef struct s_admstvariable  t_admstvariable;
typedef t_admstvariable*        p_admstvariable;
typedef const p_admstvariable   p_kadmstvariable;
typedef struct s_lexval  t_lexval;
typedef t_lexval*        p_lexval;
typedef const p_lexval   p_klexval;
typedef struct s_yaccval  t_yaccval;
typedef t_yaccval*        p_yaccval;
typedef const p_yaccval   p_kyaccval;

/*miscH*/
typedef struct s_slist t_slist;
typedef t_slist* p_slist;
FILE *stdadmstdbgimpl;
FILE *stdadmstdbgimpl;
#define stdadmstdbg (stdadmstdbgimpl?stdadmstdbgimpl:stderr)
int admsmain(const char*xcode,const char*xflag,const char*vacode);
int adms_global_nbadmstnew(void);
int adms_global_nbadmstdestroy(void);
void adms_global_increment_nbadmstnew(void);
void adms_global_increment_nbadmstdestroy(void);
/*-- admst/new prototypes --*/
p_admst adms_admst_newbd (p_admst myprevious,p_admst mypreviouspath,const admse item);
p_admst adms_admst_newbe (p_admst myprevious,p_admst mypreviouspath,const admse item);
p_admst adms_admst_newbi (p_admst myprevious,p_admst mypreviouspath,const int item);
p_admst adms_admst_newbr (p_admst myprevious,p_admst mypreviouspath,const double item);
p_admst adms_admst_newbs (p_admst myprevious,p_admst mypreviouspath,char* item);
p_admst adms_admst_newns (p_admst myprevious,p_admst mypreviouspath,char* item);
p_admst adms_admst_newks (char* item);
p_admst adms_admst_newpa (p_admst myprevious,p_admst mypreviouspath,const p_adms item);
p_admst adms_admst_newpn (p_admst myprevious,p_admst mypreviouspath,p_admst item);
p_admst adms_admst_newpc (p_admst myprevious,p_admst mypreviouspath,p_attribute item);
p_admst adms_admst_newpd (p_admst myprevious,p_admst mypreviouspath,p_admstvariable item);
p_admst adms_admst_newla (p_admst myprevious,p_admst mypreviouspath,p_slist item);
p_admst adms_admst_newln (p_admst myprevious,p_admst mypreviouspath,p_slist item);
p_admst adms_admst_newpp (p_admst myprevious,p_admst mypreviouspath,admse item);

/*-- Miscellaneous routines --*/

const double adms_dzero;
double adms_NAN;
p_admst aread (p_admst myadmst);
void deref(p_admst mystack);
union admsu
{
  int i;
  double r;
  char* s;
  p_adms p;
};
const int minusone;

int adms_strtol (p_ktransform mytransform,const char* mynumber);
double adms_strtod (p_ktransform mytransform,const char* myreal);
void bp(void);
char*adms_integertostring(int value);
char*adms_doubletostring(double value);
int adms_setenv(const char* myname,const char* myvalue);
int adms_file_isregular(const char* myfilename);
int adms_file_isdirectory(const char* myfilename);
p_slist adms_slist_new (p_adms d);
p_slist adms_slist_copy (p_slist l);
void adms_slist_concat (p_slist* l1,p_slist l2);
p_slist adms_slist_find (p_slist l,p_kadms data);
void adms_slist_free (p_slist l);
int adms_slist_index (p_slist l, p_kadms data);
p_slist adms_slist_last (p_slist l);
unsigned int adms_slist_length (p_slist l);
p_slist adms_slist_nth (p_slist l,unsigned int  n);
p_adms adms_slist_nth_data (p_slist l,unsigned int n);
void adms_slist_print(const char* message,p_slist l);
p_adms adms_slist_pull(p_slist* l);
void adms_slist_push(p_slist* l,p_adms data);
p_slist adms_slist_reverse (p_slist l);
void adms_slist_inreverse (p_slist* l);
struct s_slist
{
  p_adms data;
  p_slist next;
};


p_admsmain root(void);
void rootnew(p_admsmain myglobaladmsmain);

typedef p_admst (t_new) (p_ktransform mytransform,p_admst dot,p_slist arguments[],const int size);
typedef p_admst (*p_new) (p_ktransform mytransform,p_admst dot,p_slist arguments[],const int size);
#define _t_new(function) p_admst (function) (p_ktransform mytransform,p_admst dot,p_slist arguments[],const int size)

typedef int (t_cmp) (p_adms myadms, p_adms myadmsref);
typedef int (*p_cmp) (p_adms myadms, p_adms myadmsref);
#define _t_cmp(function) int (function) (p_adms myadms, p_adms myadmsref)

/*-- Messaging --*/
typedef void (t_message) (const char*format, ...);
typedef void (*p_message) (const char*format, ...);
#define _t_message(function)  void (function) (const char*format, ...)

void adms_toupper(char*m);
void adms_tolower(char*m);
char*adms_kclone(const char* m);
char*adms_knclone(const char* m,const int l);
char*adms_m2nclone(const char* m,const char* n);
void adms_strconcat(char **s1,char *s2);
void adms_k2strconcat(char **s1,const char* s2);
FILE *adms_file_open_read (const char* fileName);
t_message adms_message_info_impl;
t_message adms_message_info_continue_impl;
#define adms_message_info(VAARGS)\
{\
  if((root())\
    &&(root()->_info==admse_yes))\
    adms_message_info_impl VAARGS;\
}
#define adms_message_info_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_info==admse_yes))\
    adms_message_info_continue_impl VAARGS;\
}
t_message adms_message_usage_impl;
t_message adms_message_usage_continue_impl;
#define adms_message_usage(VAARGS)\
{\
  if((root())\
    &&(root()->_usage==admse_yes))\
    adms_message_usage_impl VAARGS;\
}
#define adms_message_usage_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_usage==admse_yes))\
    adms_message_usage_continue_impl VAARGS;\
}
t_message adms_message_verbose_impl;
t_message adms_message_verbose_continue_impl;
#define adms_message_verbose(VAARGS)\
{\
  if((root())\
    &&(root()->_verbose==admse_yes))\
    adms_message_verbose_impl VAARGS;\
}
#define adms_message_verbose_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_verbose==admse_yes))\
    adms_message_verbose_continue_impl VAARGS;\
}
t_message adms_message_debug_impl;
t_message adms_message_debug_continue_impl;
#define adms_message_debug(VAARGS)\
{\
  if((root())\
    &&(root()->_debug==admse_yes))\
    adms_message_debug_impl VAARGS;\
}
#define adms_message_debug_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_debug==admse_yes))\
    adms_message_debug_continue_impl VAARGS;\
}
t_message adms_message_dbg_vla_impl;
t_message adms_message_dbg_vla_continue_impl;
#define adms_message_dbg_vla(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_vla==admse_yes))\
    adms_message_dbg_vla_impl VAARGS;\
}
#define adms_message_dbg_vla_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_vla==admse_yes))\
    adms_message_dbg_vla_continue_impl VAARGS;\
}
t_message adms_message_dbg_xml_impl;
t_message adms_message_dbg_xml_continue_impl;
#define adms_message_dbg_xml(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_xml==admse_yes))\
    adms_message_dbg_xml_impl VAARGS;\
}
#define adms_message_dbg_xml_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_xml==admse_yes))\
    adms_message_dbg_xml_continue_impl VAARGS;\
}
t_message adms_message_dbg_mem_impl;
t_message adms_message_dbg_mem_continue_impl;
#define adms_message_dbg_mem(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_mem==admse_yes))\
    adms_message_dbg_mem_impl VAARGS;\
}
#define adms_message_dbg_mem_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_dbg_mem==admse_yes))\
    adms_message_dbg_mem_continue_impl VAARGS;\
}
t_message adms_message_hint_impl;
t_message adms_message_hint_continue_impl;
#define adms_message_hint(VAARGS)\
{\
  if((root())\
    &&(root()->_hint==admse_yes))\
    adms_message_hint_impl VAARGS;\
}
#define adms_message_hint_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_hint==admse_yes))\
    adms_message_hint_continue_impl VAARGS;\
}
t_message adms_message_warning_impl;
t_message adms_message_warning_continue_impl;
#define adms_message_warning(VAARGS)\
{\
  if((root())\
    &&(root()->_warning==admse_yes))\
    adms_message_warning_impl VAARGS;\
}
#define adms_message_warning_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_warning==admse_yes))\
    adms_message_warning_continue_impl VAARGS;\
}
t_message adms_message_obsolete_impl;
t_message adms_message_obsolete_continue_impl;
#define adms_message_obsolete(VAARGS)\
{\
  if((root())\
    &&(root()->_obsolete==admse_yes))\
    adms_message_obsolete_impl VAARGS;\
}
#define adms_message_obsolete_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_obsolete==admse_yes))\
    adms_message_obsolete_continue_impl VAARGS;\
}
t_message adms_message_error_impl;
t_message adms_message_error_continue_impl;
#define adms_message_error(VAARGS)\
{\
  if((root())\
    &&(root()->_error==admse_yes))\
    adms_message_error_impl VAARGS;\
}
#define adms_message_error_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_error==admse_yes))\
    adms_message_error_continue_impl VAARGS;\
}
t_message adms_message_fatal_impl;
t_message adms_message_fatal_continue_impl;
#define adms_message_fatal(VAARGS)\
{\
  if((root())\
    &&(root()->_fatal==admse_yes))\
    adms_message_fatal_impl VAARGS;\
}
#define adms_message_fatal_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_fatal==admse_yes))\
    adms_message_fatal_continue_impl VAARGS;\
}
t_message adms_message_admstdbg_impl;
t_message adms_message_admstdbg_continue_impl;
#define adms_message_admstdbg(VAARGS)\
{\
  if((root())\
    &&(root()->_admstdbg==admse_yes))\
    adms_message_admstdbg_impl VAARGS;\
}
#define adms_message_admstdbg_continue(VAARGS)\
{\
  if((root())\
    &&(root()->_admstdbg==admse_yes))\
    adms_message_admstdbg_continue_impl VAARGS;\
}

char* aprintf (p_ktransform mytransform,p_kadmst myadmst);

/* ------- adms -------------- */
#define adms_adms(member) ((p_adms)(member))
struct s_adms {
  admse _datatypename;
  p_slist _attribute;
  p_slist _variable;
};
char*adms_adms_uid (p_adms myadms);
void adms_adms_valueto_datatypename (p_adms myadms,int _datatypename);
void adms_adms_valueto_attribute (p_adms myadms,p_slist _attribute);
void adms_adms_valueto_variable (p_adms myadms,p_slist _variable);

/* ------- simulator -------------- */
#define adms_simulator(member) ((p_simulator)(member))
struct s_simulator {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  char* _currentdate;
  int _currentdate_isdefault : 2;
  char* _developer;
  int _developer_isdefault : 2;
  char* _fullname;
  int _fullname_isdefault : 2;
  char* _package_name;
  int _package_name_isdefault : 2;
  char* _package_tarname;
  int _package_tarname_isdefault : 2;
  char* _package_version;
  int _package_version_isdefault : 2;
  char* _package_string;
  int _package_string_isdefault : 2;
  char* _package_bugreport;
  int _package_bugreport_isdefault : 2;
  p_probe _probe;
  int _probe_isdefault : 2;
  char* _tmp;
  int _tmp_isdefault : 2;
  char* _tmp1;
  int _tmp1_isdefault : 2;
  p_branch _br1;
  int _br1_isdefault : 2;
  p_branch _br2;
  int _br2_isdefault : 2;
  p_source _sr1;
  int _sr1_isdefault : 2;
  char* _ddx;
  int _ddx_isdefault : 2;
};
char*adms_simulator_uid (p_simulator mysimulator);
p_simulator adms_simulator_new (const char* myname);
void adms_simulator_free(p_simulator mysimulator);
void adms_simulator_valueto_name (p_simulator mysimulator,const char* _name);
void adms_simulator_valueto_currentdate (p_simulator mysimulator,const char* _currentdate);
void adms_simulator_valueto_developer (p_simulator mysimulator,const char* _developer);
void adms_simulator_valueto_fullname (p_simulator mysimulator,const char* _fullname);
void adms_simulator_valueto_package_name (p_simulator mysimulator,const char* _package_name);
void adms_simulator_valueto_package_tarname (p_simulator mysimulator,const char* _package_tarname);
void adms_simulator_valueto_package_version (p_simulator mysimulator,const char* _package_version);
void adms_simulator_valueto_package_string (p_simulator mysimulator,const char* _package_string);
void adms_simulator_valueto_package_bugreport (p_simulator mysimulator,const char* _package_bugreport);
void adms_simulator_valueto_probe (p_simulator mysimulator,p_probe _probe);
void adms_simulator_valueto_tmp (p_simulator mysimulator,const char* _tmp);
void adms_simulator_valueto_tmp1 (p_simulator mysimulator,const char* _tmp1);
void adms_simulator_valueto_br1 (p_simulator mysimulator,p_branch _br1);
void adms_simulator_valueto_br2 (p_simulator mysimulator,p_branch _br2);
void adms_simulator_valueto_sr1 (p_simulator mysimulator,p_source _sr1);
void adms_simulator_valueto_ddx (p_simulator mysimulator,const char* _ddx);

/* ------- admsmain -------------- */
#define adms_admsmain(member) ((p_admsmain)(member))
struct s_admsmain {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  int _argc;
  int _argc_isdefault : 2;
  char* _fullfilename;
  int _fullfilename_isdefault : 2;
  char* _filename;
  int _filename_isdefault : 2;
  char* _curfilename;
  int _curfilename_isdefault : 2;
  int _curline;
  int _curline_isdefault : 2;
  int _fpos;
  int _fpos_isdefault : 2;
  p_simulator _simulator;
  int _simulator_isdefault : 2;
  admse _info;
  int _info_isdefault : 2;
  admse _usage;
  int _usage_isdefault : 2;
  admse _verbose;
  int _verbose_isdefault : 2;
  admse _hint;
  int _hint_isdefault : 2;
  admse _warning;
  int _warning_isdefault : 2;
  admse _obsolete;
  int _obsolete_isdefault : 2;
  admse _debug;
  int _debug_isdefault : 2;
  admse _dbg_vla;
  int _dbg_vla_isdefault : 2;
  admse _dbg_xml;
  int _dbg_xml_isdefault : 2;
  admse _error;
  int _error_isdefault : 2;
  admse _fatal;
  int _fatal_isdefault : 2;
  admse _dbg_mem;
  int _dbg_mem_isdefault : 2;
  p_slist _module;
  int _module_isdefault : 2;
  p_slist _discipline;
  int _discipline_isdefault : 2;
  p_slist _nature;
  int _nature_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
  p_slist _argv;
  int _argv_isdefault : 2;
  p_slist _transform;
  int _transform_isdefault : 2;
  p_slist _invtransform;
  int _invtransform_isdefault : 2;
  p_slist _itransform;
  int _itransform_isdefault : 2;
  p_slist _itransforminsideapplytemplate;
  int _itransforminsideapplytemplate_isdefault : 2;
  p_slist _valueof;
  int _valueof_isdefault : 2;
};
char*adms_admsmain_uid (p_admsmain myadmsmain);
p_admsmain adms_admsmain_new (const char* myname);
void adms_admsmain_free(p_admsmain myadmsmain);
void adms_admsmain_valueto_name (p_admsmain myadmsmain,const char* _name);
void adms_admsmain_valueto_argc (p_admsmain myadmsmain,int _argc);
void adms_admsmain_valueto_fullfilename (p_admsmain myadmsmain,const char* _fullfilename);
void adms_admsmain_valueto_filename (p_admsmain myadmsmain,const char* _filename);
void adms_admsmain_valueto_curfilename (p_admsmain myadmsmain,const char* _curfilename);
void adms_admsmain_valueto_curline (p_admsmain myadmsmain,int _curline);
void adms_admsmain_valueto_fpos (p_admsmain myadmsmain,int _fpos);
void adms_admsmain_valueto_simulator (p_admsmain myadmsmain,p_simulator _simulator);
void adms_admsmain_valueto_info (p_admsmain myadmsmain,admse _info);
void adms_admsmain_valueto_usage (p_admsmain myadmsmain,admse _usage);
void adms_admsmain_valueto_verbose (p_admsmain myadmsmain,admse _verbose);
void adms_admsmain_valueto_hint (p_admsmain myadmsmain,admse _hint);
void adms_admsmain_valueto_warning (p_admsmain myadmsmain,admse _warning);
void adms_admsmain_valueto_obsolete (p_admsmain myadmsmain,admse _obsolete);
void adms_admsmain_valueto_debug (p_admsmain myadmsmain,admse _debug);
void adms_admsmain_valueto_dbg_vla (p_admsmain myadmsmain,admse _dbg_vla);
void adms_admsmain_valueto_dbg_xml (p_admsmain myadmsmain,admse _dbg_xml);
void adms_admsmain_valueto_error (p_admsmain myadmsmain,admse _error);
void adms_admsmain_valueto_fatal (p_admsmain myadmsmain,admse _fatal);
void adms_admsmain_valueto_dbg_mem (p_admsmain myadmsmain,admse _dbg_mem);
void adms_admsmain_valueto_module (p_admsmain myadmsmain,p_slist _module);
p_module adms_admsmain_list_module_prepend_by_id_once_or_abort (p_admsmain mymyadmsmain,const char* myname);
p_module adms_admsmain_list_module_lookup_by_id (p_admsmain mymyadmsmain,const char* myname);
void adms_admsmain_valueto_discipline (p_admsmain myadmsmain,p_slist _discipline);
void adms_admsmain_list_discipline_prepend_once_or_abort (p_admsmain mymyadmsmain,p_discipline mydiscipline);
p_discipline adms_admsmain_list_discipline_lookup_by_id (p_admsmain mymyadmsmain,const char* myname);
void adms_admsmain_valueto_nature (p_admsmain myadmsmain,p_slist _nature);
p_nature adms_admsmain_list_nature_prepend_by_id_once_or_abort (p_admsmain mymyadmsmain,const char* myaccess);
p_nature adms_admsmain_list_nature_lookup_by_id (p_admsmain mymyadmsmain,const char* myaccess);
void adms_admsmain_valueto_variable (p_admsmain myadmsmain,p_slist _variable);
void adms_admsmain_valueto_argv (p_admsmain myadmsmain,p_slist _argv);
void adms_admsmain_valueto_transform (p_admsmain myadmsmain,p_slist _transform);
void adms_admsmain_valueto_invtransform (p_admsmain myadmsmain,p_slist _invtransform);
void adms_admsmain_valueto_itransform (p_admsmain myadmsmain,p_slist _itransform);
void adms_admsmain_valueto_itransforminsideapplytemplate (p_admsmain myadmsmain,p_slist _itransforminsideapplytemplate);
void adms_admsmain_valueto_valueof (p_admsmain myadmsmain,p_slist _valueof);

/* ------- list -------------- */
#define adms_list(member) ((p_list)(member))
struct s_list {
  t_adms _adms;
  char* _datatype;
  int _datatype_isdefault : 2;
  p_slist _item;
  int _item_isdefault : 2;
};
char*adms_list_uid (p_list mylist);
p_list adms_list_new (const char* mydatatype);
void adms_list_free(p_list mylist);
void adms_list_valueto_datatype (p_list mylist,const char* _datatype);
void adms_list_valueto_item (p_list mylist,p_slist _item);

/* ------- nature -------------- */
#define adms_nature(member) ((p_nature)(member))
struct s_nature {
  t_adms _adms;
  char* _access;
  int _access_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_number _abstol;
  int _abstol_isdefault : 2;
  p_nature _base;
  int _base_isdefault : 2;
  char* _ddt_name;
  int _ddt_name_isdefault : 2;
  p_nature _ddt_nature;
  int _ddt_nature_isdefault : 2;
  char* _idt_name;
  int _idt_name_isdefault : 2;
  p_nature _idt_nature;
  int _idt_nature_isdefault : 2;
  char* _units;
  int _units_isdefault : 2;
};
char*adms_nature_uid (p_nature mynature);
p_nature adms_nature_new (const char* myaccess);
void adms_nature_free(p_nature mynature);
void adms_nature_valueto_access (p_nature mynature,const char* _access);
void adms_nature_valueto_name (p_nature mynature,const char* _name);
void adms_nature_valueto_abstol (p_nature mynature,p_number _abstol);
void adms_nature_valueto_base (p_nature mynature,p_nature _base);
void adms_nature_valueto_ddt_name (p_nature mynature,const char* _ddt_name);
void adms_nature_valueto_ddt_nature (p_nature mynature,p_nature _ddt_nature);
void adms_nature_valueto_idt_name (p_nature mynature,const char* _idt_name);
void adms_nature_valueto_idt_nature (p_nature mynature,p_nature _idt_nature);
void adms_nature_valueto_units (p_nature mynature,const char* _units);

/* ------- discipline -------------- */
#define adms_discipline(member) ((p_discipline)(member))
struct s_discipline {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  p_nature _flow;
  int _flow_isdefault : 2;
  p_nature _potential;
  int _potential_isdefault : 2;
  admse _domain;
  int _domain_isdefault : 2;
};
char*adms_discipline_uid (p_discipline mydiscipline);
p_discipline adms_discipline_new (const char* myname);
void adms_discipline_free(p_discipline mydiscipline);
void adms_discipline_valueto_name (p_discipline mydiscipline,const char* _name);
void adms_discipline_valueto_flow (p_discipline mydiscipline,p_nature _flow);
void adms_discipline_valueto_potential (p_discipline mydiscipline,p_nature _potential);
void adms_discipline_valueto_domain (p_discipline mydiscipline,admse _domain);

/* ------- module -------------- */
#define adms_module(member) ((p_module)(member))
struct s_module {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  p_slist _node;
  int _node_isdefault : 2;
  p_slist _nodealias;
  int _nodealias_isdefault : 2;
  p_slist _branch;
  int _branch_isdefault : 2;
  p_slist _branchalias;
  int _branchalias_isdefault : 2;
  p_slist _analogfunction;
  int _analogfunction_isdefault : 2;
  p_slist _instance;
  int _instance_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
  p_analog _analog;
  int _analog_isdefault : 2;
  p_slist _block;
  int _block_isdefault : 2;
  p_slist _blockvariable;
  int _blockvariable_isdefault : 2;
  p_slist _assignment;
  int _assignment_isdefault : 2;
  p_slist _callfunction;
  int _callfunction_isdefault : 2;
  p_slist _contribution;
  int _contribution_isdefault : 2;
  p_slist _conditional;
  int _conditional_isdefault : 2;
  p_slist _case;
  int _case_isdefault : 2;
  p_slist _forloop;
  int _forloop_isdefault : 2;
  p_slist _whileloop;
  int _whileloop_isdefault : 2;
  p_slist _instantiator;
  int _instantiator_isdefault : 2;
  p_slist _expression;
  int _expression_isdefault : 2;
  p_slist _jacobian;
  int _jacobian_isdefault : 2;
  p_slist _probe;
  int _probe_isdefault : 2;
  p_slist _source;
  int _source_isdefault : 2;
  p_slist _range;
  int _range_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
  p_evaluation _evaluation;
  int _evaluation_isdefault : 2;
};
char*adms_module_uid (p_module mymodule);
p_module adms_module_new (const char* myname);
void adms_module_free(p_module mymodule);
void adms_module_valueto_name (p_module mymodule,const char* _name);
void adms_module_valueto_node (p_module mymodule,p_slist _node);
p_node adms_module_list_node_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,const char* myname);
p_node adms_module_list_node_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,const char* myname);
p_node adms_module_list_node_lookup_by_id (p_module mymymodule,p_module mymodule,const char* myname);
void adms_module_valueto_nodealias (p_module mymodule,p_slist _nodealias);
p_nodealias adms_module_list_nodealias_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,const char* myname);
p_nodealias adms_module_list_nodealias_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,const char* myname);
p_nodealias adms_module_list_nodealias_lookup_by_id (p_module mymymodule,p_module mymodule,const char* myname);
void adms_module_valueto_branch (p_module mymodule,p_slist _branch);
p_branch adms_module_list_branch_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_node mypnode,p_node mynnode);
void adms_module_valueto_branchalias (p_module mymodule,p_slist _branchalias);
p_branchalias adms_module_list_branchalias_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,const char* myname);
p_branchalias adms_module_list_branchalias_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,const char* myname);
p_branchalias adms_module_list_branchalias_lookup_by_id (p_module mymymodule,p_module mymodule,const char* myname);
void adms_module_valueto_analogfunction (p_module mymodule,p_slist _analogfunction);
void adms_module_list_analogfunction_prepend_once_or_abort (p_module mymymodule,p_analogfunction myanalogfunction);
void adms_module_valueto_instance (p_module mymodule,p_slist _instance);
p_instance adms_module_list_instance_prepend_by_id_once_or_abort (p_module mymymodule,p_module myinstantiator,p_module mymodule,const char* myname);
void adms_module_valueto_variable (p_module mymodule,p_slist _variable);
void adms_module_list_variable_prepend_once_or_abort (p_module mymymodule,p_variableprototype myvariable);
p_variableprototype adms_module_list_variable_lookup_by_id (p_module mymymodule,p_module mymodule,p_lexval mylexval,p_adms myblock);
void adms_module_valueto_analog (p_module mymodule,p_analog _analog);
void adms_module_valueto_block (p_module mymodule,p_slist _block);
void adms_module_valueto_blockvariable (p_module mymodule,p_slist _blockvariable);
void adms_module_list_blockvariable_prepend_once_or_abort (p_module mymymodule,p_blockvariable myblockvariable);
p_blockvariable adms_module_list_blockvariable_lookup_by_id (p_module mymymodule,p_block myblock);
void adms_module_valueto_assignment (p_module mymodule,p_slist _assignment);
void adms_module_valueto_callfunction (p_module mymodule,p_slist _callfunction);
void adms_module_valueto_contribution (p_module mymodule,p_slist _contribution);
void adms_module_valueto_conditional (p_module mymodule,p_slist _conditional);
void adms_module_valueto_case (p_module mymodule,p_slist _case);
void adms_module_valueto_forloop (p_module mymodule,p_slist _forloop);
void adms_module_valueto_whileloop (p_module mymodule,p_slist _whileloop);
void adms_module_valueto_instantiator (p_module mymodule,p_slist _instantiator);
void adms_module_valueto_expression (p_module mymodule,p_slist _expression);
void adms_module_valueto_jacobian (p_module mymodule,p_slist _jacobian);
void adms_module_valueto_probe (p_module mymodule,p_slist _probe);
p_probe adms_module_list_probe_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature);
void adms_module_valueto_source (p_module mymodule,p_slist _source);
p_source adms_module_list_source_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature);
void adms_module_valueto_range (p_module mymodule,p_slist _range);
p_range adms_module_list_range_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_expression myinfexpr,p_expression mysupexpr);
void adms_module_valueto_attribute (p_module mymodule,p_slist _attribute);
void adms_module_valueto_evaluation (p_module mymodule,p_evaluation _evaluation);

/* ------- analogfunction -------------- */
#define adms_analogfunction(member) ((p_analogfunction)(member))
struct s_analogfunction {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  admse _type;
  int _type_isdefault : 2;
  p_adms _tree;
  int _tree_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_analogfunction_uid (p_analogfunction myanalogfunction);
p_analogfunction adms_analogfunction_new (p_module mymodule,p_lexval mylexval);
void adms_analogfunction_free(p_analogfunction myanalogfunction);
void adms_analogfunction_valueto_module (p_analogfunction myanalogfunction,p_module _module);
void adms_analogfunction_valueto_lexval (p_analogfunction myanalogfunction,p_lexval _lexval);
void adms_analogfunction_valueto_type (p_analogfunction myanalogfunction,admse _type);
void adms_analogfunction_valueto_tree (p_analogfunction myanalogfunction,p_adms _tree);
void adms_analogfunction_valueto_variable (p_analogfunction myanalogfunction,p_slist _variable);
void adms_analogfunction_list_variable_prepend_once_or_abort (p_analogfunction mymyanalogfunction,p_variableprototype myvariable);
p_variableprototype adms_analogfunction_list_variable_lookup_by_id (p_analogfunction mymyanalogfunction,p_module mymodule,p_lexval mylexval,p_adms myblock);
void adms_analogfunction_valueto_attribute (p_analogfunction myanalogfunction,p_slist _attribute);

/* ------- nodealias -------------- */
#define adms_nodealias(member) ((p_nodealias)(member))
struct s_nodealias {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_node _node;
  int _node_isdefault : 2;
};
char*adms_nodealias_uid (p_nodealias mynodealias);
p_nodealias adms_nodealias_new (p_module mymodule,const char* myname);
void adms_nodealias_free(p_nodealias mynodealias);
void adms_nodealias_valueto_module (p_nodealias mynodealias,p_module _module);
void adms_nodealias_valueto_name (p_nodealias mynodealias,const char* _name);
void adms_nodealias_valueto_node (p_nodealias mynodealias,p_node _node);

/* ------- node -------------- */
#define adms_node(member) ((p_node)(member))
struct s_node {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  admse _direction;
  int _direction_isdefault : 2;
  p_discipline _discipline;
  int _discipline_isdefault : 2;
  admse _grounded;
  int _grounded_isdefault : 2;
  admse _location;
  int _location_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_node_uid (p_node mynode);
p_node adms_node_new (p_module mymodule,const char* myname);
void adms_node_free(p_node mynode);
void adms_node_valueto_module (p_node mynode,p_module _module);
void adms_node_valueto_name (p_node mynode,const char* _name);
void adms_node_valueto_direction (p_node mynode,admse _direction);
void adms_node_valueto_discipline (p_node mynode,p_discipline _discipline);
void adms_node_valueto_grounded (p_node mynode,admse _grounded);
void adms_node_valueto_location (p_node mynode,admse _location);
void adms_node_valueto_attribute (p_node mynode,p_slist _attribute);

/* ------- branchalias -------------- */
#define adms_branchalias(member) ((p_branchalias)(member))
struct s_branchalias {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_branch _branch;
  int _branch_isdefault : 2;
};
char*adms_branchalias_uid (p_branchalias mybranchalias);
p_branchalias adms_branchalias_new (p_module mymodule,const char* myname);
void adms_branchalias_free(p_branchalias mybranchalias);
void adms_branchalias_valueto_module (p_branchalias mybranchalias,p_module _module);
void adms_branchalias_valueto_name (p_branchalias mybranchalias,const char* _name);
void adms_branchalias_valueto_branch (p_branchalias mybranchalias,p_branch _branch);

/* ------- branch -------------- */
#define adms_branch(member) ((p_branch)(member))
struct s_branch {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_node _pnode;
  int _pnode_isdefault : 2;
  p_node _nnode;
  int _nnode_isdefault : 2;
  p_discipline _discipline;
  int _discipline_isdefault : 2;
  admse _grounded;
  int _grounded_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_branch_uid (p_branch mybranch);
p_branch adms_branch_new (p_module mymodule,p_node mypnode,p_node mynnode);
void adms_branch_free(p_branch mybranch);
void adms_branch_valueto_module (p_branch mybranch,p_module _module);
void adms_branch_valueto_pnode (p_branch mybranch,p_node _pnode);
void adms_branch_valueto_nnode (p_branch mybranch,p_node _nnode);
void adms_branch_valueto_discipline (p_branch mybranch,p_discipline _discipline);
void adms_branch_valueto_grounded (p_branch mybranch,admse _grounded);
void adms_branch_valueto_attribute (p_branch mybranch,p_slist _attribute);

/* ------- variableprototype -------------- */
#define adms_variableprototype(member) ((p_variableprototype)(member))
struct s_variableprototype {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  p_adms _block;
  int _block_isdefault : 2;
  admse _dependency;
  int _dependency_isdefault : 2;
  admse _static;
  int _static_isdefault : 2;
  admse _dynamic;
  int _dynamic_isdefault : 2;
  admse _sizetype;
  int _sizetype_isdefault : 2;
  admse _parametertype;
  int _parametertype_isdefault : 2;
  admse _type;
  int _type_isdefault : 2;
  p_number _maxsize;
  int _maxsize_isdefault : 2;
  p_number _minsize;
  int _minsize_isdefault : 2;
  admse _input;
  int _input_isdefault : 2;
  admse _output;
  int _output_isdefault : 2;
  admse _scope;
  int _scope_isdefault : 2;
  p_expression _default;
  int _default_isdefault : 2;
  admse _derivate;
  int _derivate_isdefault : 2;
  admse _isstate;
  int _isstate_isdefault : 2;
  admse _usedinmodel;
  int _usedinmodel_isdefault : 2;
  admse _usedininstance;
  int _usedininstance_isdefault : 2;
  admse _usedininitial_step;
  int _usedininitial_step_isdefault : 2;
  admse _usedinevaluate;
  int _usedinevaluate_isdefault : 2;
  admse _usedinnoise;
  int _usedinnoise_isdefault : 2;
  admse _usedinfinal;
  int _usedinfinal_isdefault : 2;
  admse _setinmodel;
  int _setinmodel_isdefault : 2;
  admse _setininstance;
  int _setininstance_isdefault : 2;
  admse _setininitial_step;
  int _setininitial_step_isdefault : 2;
  admse _setinevaluate;
  int _setinevaluate_isdefault : 2;
  admse _setinnoise;
  int _setinnoise_isdefault : 2;
  admse _setinfinal;
  int _setinfinal_isdefault : 2;
  admse _setingetprev;
  int _setingetprev_isdefault : 2;
  admse _TemperatureDependent;
  int _TemperatureDependent_isdefault : 2;
  admse _OPdependent;
  int _OPdependent_isdefault : 2;
  admse _insource;
  int _insource_isdefault : 2;
  int _vcount;
  int _vcount_isdefault : 2;
  p_assignment _vlast;
  int _vlast_isdefault : 2;
  p_slist _arraydefault;
  int _arraydefault_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
  p_slist _alias;
  int _alias_isdefault : 2;
  p_slist _range;
  int _range_isdefault : 2;
  p_slist _probe;
  int _probe_isdefault : 2;
  p_slist _ddxprobe;
  int _ddxprobe_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
  p_slist _assignment;
  int _assignment_isdefault : 2;
  p_slist _instance;
  int _instance_isdefault : 2;
};
char*adms_variableprototype_uid (p_variableprototype myvariableprototype);
p_variableprototype adms_variableprototype_new (p_module mymodule,p_lexval mylexval,p_adms myblock);
void adms_variableprototype_free(p_variableprototype myvariableprototype);
void adms_variableprototype_valueto_module (p_variableprototype myvariableprototype,p_module _module);
void adms_variableprototype_valueto_lexval (p_variableprototype myvariableprototype,p_lexval _lexval);
void adms_variableprototype_valueto_block (p_variableprototype myvariableprototype,p_adms _block);
void adms_variableprototype_valueto_dependency (p_variableprototype myvariableprototype,admse _dependency);
void adms_variableprototype_valueto_static (p_variableprototype myvariableprototype,admse _static);
void adms_variableprototype_valueto_dynamic (p_variableprototype myvariableprototype,admse _dynamic);
void adms_variableprototype_valueto_sizetype (p_variableprototype myvariableprototype,admse _sizetype);
void adms_variableprototype_valueto_parametertype (p_variableprototype myvariableprototype,admse _parametertype);
void adms_variableprototype_valueto_type (p_variableprototype myvariableprototype,admse _type);
void adms_variableprototype_valueto_maxsize (p_variableprototype myvariableprototype,p_number _maxsize);
void adms_variableprototype_valueto_minsize (p_variableprototype myvariableprototype,p_number _minsize);
void adms_variableprototype_valueto_input (p_variableprototype myvariableprototype,admse _input);
void adms_variableprototype_valueto_output (p_variableprototype myvariableprototype,admse _output);
void adms_variableprototype_valueto_scope (p_variableprototype myvariableprototype,admse _scope);
void adms_variableprototype_valueto_default (p_variableprototype myvariableprototype,p_expression _default);
void adms_variableprototype_valueto_derivate (p_variableprototype myvariableprototype,admse _derivate);
void adms_variableprototype_valueto_isstate (p_variableprototype myvariableprototype,admse _isstate);
void adms_variableprototype_valueto_usedinmodel (p_variableprototype myvariableprototype,admse _usedinmodel);
void adms_variableprototype_valueto_usedininstance (p_variableprototype myvariableprototype,admse _usedininstance);
void adms_variableprototype_valueto_usedininitial_step (p_variableprototype myvariableprototype,admse _usedininitial_step);
void adms_variableprototype_valueto_usedinevaluate (p_variableprototype myvariableprototype,admse _usedinevaluate);
void adms_variableprototype_valueto_usedinnoise (p_variableprototype myvariableprototype,admse _usedinnoise);
void adms_variableprototype_valueto_usedinfinal (p_variableprototype myvariableprototype,admse _usedinfinal);
void adms_variableprototype_valueto_setinmodel (p_variableprototype myvariableprototype,admse _setinmodel);
void adms_variableprototype_valueto_setininstance (p_variableprototype myvariableprototype,admse _setininstance);
void adms_variableprototype_valueto_setininitial_step (p_variableprototype myvariableprototype,admse _setininitial_step);
void adms_variableprototype_valueto_setinevaluate (p_variableprototype myvariableprototype,admse _setinevaluate);
void adms_variableprototype_valueto_setinnoise (p_variableprototype myvariableprototype,admse _setinnoise);
void adms_variableprototype_valueto_setinfinal (p_variableprototype myvariableprototype,admse _setinfinal);
void adms_variableprototype_valueto_setingetprev (p_variableprototype myvariableprototype,admse _setingetprev);
void adms_variableprototype_valueto_TemperatureDependent (p_variableprototype myvariableprototype,admse _TemperatureDependent);
void adms_variableprototype_valueto_OPdependent (p_variableprototype myvariableprototype,admse _OPdependent);
void adms_variableprototype_valueto_insource (p_variableprototype myvariableprototype,admse _insource);
void adms_variableprototype_valueto_vcount (p_variableprototype myvariableprototype,int _vcount);
void adms_variableprototype_valueto_vlast (p_variableprototype myvariableprototype,p_assignment _vlast);
void adms_variableprototype_valueto_arraydefault (p_variableprototype myvariableprototype,p_slist _arraydefault);
void adms_variableprototype_valueto_attribute (p_variableprototype myvariableprototype,p_slist _attribute);
void adms_variableprototype_valueto_alias (p_variableprototype myvariableprototype,p_slist _alias);
void adms_variableprototype_list_alias_prepend_once_or_abort (p_variableprototype mymyvariableprototype,const char* myalias);
void adms_variableprototype_valueto_range (p_variableprototype myvariableprototype,p_slist _range);
void adms_variableprototype_valueto_probe (p_variableprototype myvariableprototype,p_slist _probe);
void adms_variableprototype_valueto_ddxprobe (p_variableprototype myvariableprototype,p_slist _ddxprobe);
void adms_variableprototype_valueto_variable (p_variableprototype myvariableprototype,p_slist _variable);
void adms_variableprototype_valueto_assignment (p_variableprototype myvariableprototype,p_slist _assignment);
void adms_variableprototype_valueto_instance (p_variableprototype myvariableprototype,p_slist _instance);

/* ------- source -------------- */
#define adms_source(member) ((p_source)(member))
struct s_source {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_branch _branch;
  int _branch_isdefault : 2;
  p_nature _nature;
  int _nature_isdefault : 2;
  p_discipline _discipline;
  int _discipline_isdefault : 2;
  admse _static;
  int _static_isdefault : 2;
  admse _dynamic;
  int _dynamic_isdefault : 2;
  admse _whitenoise;
  int _whitenoise_isdefault : 2;
  admse _flickernoise;
  int _flickernoise_isdefault : 2;
  admse _grounded;
  int _grounded_isdefault : 2;
  admse _switch;
  int _switch_isdefault : 2;
  admse _type;
  int _type_isdefault : 2;
  p_slist _probe;
  int _probe_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_source_uid (p_source mysource);
p_source adms_source_new (p_module mymodule,p_branch mybranch,p_nature mynature);
void adms_source_free(p_source mysource);
void adms_source_valueto_module (p_source mysource,p_module _module);
void adms_source_valueto_branch (p_source mysource,p_branch _branch);
void adms_source_valueto_nature (p_source mysource,p_nature _nature);
void adms_source_valueto_discipline (p_source mysource,p_discipline _discipline);
void adms_source_valueto_static (p_source mysource,admse _static);
void adms_source_valueto_dynamic (p_source mysource,admse _dynamic);
void adms_source_valueto_whitenoise (p_source mysource,admse _whitenoise);
void adms_source_valueto_flickernoise (p_source mysource,admse _flickernoise);
void adms_source_valueto_grounded (p_source mysource,admse _grounded);
void adms_source_valueto_switch (p_source mysource,admse _switch);
void adms_source_valueto_type (p_source mysource,admse _type);
void adms_source_valueto_probe (p_source mysource,p_slist _probe);
void adms_source_valueto_attribute (p_source mysource,p_slist _attribute);

/* ------- range -------------- */
#define adms_range(member) ((p_range)(member))
struct s_range {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_expression _infexpr;
  int _infexpr_isdefault : 2;
  p_expression _supexpr;
  int _supexpr_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  admse _infboundtype;
  int _infboundtype_isdefault : 2;
  admse _supboundtype;
  int _supboundtype_isdefault : 2;
  admse _type;
  int _type_isdefault : 2;
};
char*adms_range_uid (p_range myrange);
p_range adms_range_new (p_module mymodule,p_expression myinfexpr,p_expression mysupexpr);
void adms_range_free(p_range myrange);
void adms_range_valueto_module (p_range myrange,p_module _module);
void adms_range_valueto_infexpr (p_range myrange,p_expression _infexpr);
void adms_range_valueto_supexpr (p_range myrange,p_expression _supexpr);
void adms_range_valueto_name (p_range myrange,const char* _name);
void adms_range_valueto_infboundtype (p_range myrange,admse _infboundtype);
void adms_range_valueto_supboundtype (p_range myrange,admse _supboundtype);
void adms_range_valueto_type (p_range myrange,admse _type);

/* ------- jacobian -------------- */
#define adms_jacobian(member) ((p_jacobian)(member))
struct s_jacobian {
  t_adms _adms;
  p_module _module;
  int _module_isdefault : 2;
  p_node _row;
  int _row_isdefault : 2;
  p_node _column;
  int _column_isdefault : 2;
  admse _diagonal;
  int _diagonal_isdefault : 2;
  admse _static;
  int _static_isdefault : 2;
  admse _dynamic;
  int _dynamic_isdefault : 2;
};
char*adms_jacobian_uid (p_jacobian myjacobian);
p_jacobian adms_jacobian_new (p_module mymodule,p_node myrow,p_node mycolumn);
void adms_jacobian_free(p_jacobian myjacobian);
void adms_jacobian_valueto_module (p_jacobian myjacobian,p_module _module);
void adms_jacobian_valueto_row (p_jacobian myjacobian,p_node _row);
void adms_jacobian_valueto_column (p_jacobian myjacobian,p_node _column);
void adms_jacobian_valueto_diagonal (p_jacobian myjacobian,admse _diagonal);
void adms_jacobian_valueto_static (p_jacobian myjacobian,admse _static);
void adms_jacobian_valueto_dynamic (p_jacobian myjacobian,admse _dynamic);

/* ------- analog -------------- */
#define adms_analog(member) ((p_analog)(member))
struct s_analog {
  t_adms _adms;
  p_adms _code;
  int _code_isdefault : 2;
};
char*adms_analog_uid (p_analog myanalog);
p_analog adms_analog_new (p_adms mycode);
void adms_analog_free(p_analog myanalog);
void adms_analog_valueto_code (p_analog myanalog,p_adms _code);

/* ------- math -------------- */
#define adms_math(member) ((p_math)(member))
struct s_math {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  double _value;
  int _value_isdefault : 2;
  admse _static;
  int _static_isdefault : 2;
  admse _dynamic;
  int _dynamic_isdefault : 2;
  admse _dependency;
  int _dependency_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_math_uid (p_math mymath);
p_math adms_math_new (const char* myname);
void adms_math_free(p_math mymath);
void adms_math_valueto_name (p_math mymath,const char* _name);
void adms_math_valueto_value (p_math mymath,double _value);
void adms_math_valueto_static (p_math mymath,admse _static);
void adms_math_valueto_dynamic (p_math mymath,admse _dynamic);
void adms_math_valueto_dependency (p_math mymath,admse _dependency);
void adms_math_valueto_attribute (p_math mymath,p_slist _attribute);

/* ------- string -------------- */
#define adms_string(member) ((p_string)(member))
struct s_string {
  t_math _math;
  char* _value;
  int _value_isdefault : 2;
};
char*adms_string_uid (p_string mystring);
p_string adms_string_new (const char* myvalue);
void adms_string_free(p_string mystring);
void adms_string_valueto_value (p_string mystring,const char* _value);

/* ------- subexpression -------------- */
#define adms_subexpression(member) ((p_subexpression)(member))
struct s_subexpression {
  t_math _math;
  p_expression _expression;
  int _expression_isdefault : 2;
};
char*adms_subexpression_uid (p_subexpression mysubexpression);
p_subexpression adms_subexpression_new (p_expression myexpression);
void adms_subexpression_free(p_subexpression mysubexpression);
void adms_subexpression_valueto_expression (p_subexpression mysubexpression,p_expression _expression);

/* ------- mapply_unary -------------- */
#define adms_mapply_unary(member) ((p_mapply_unary)(member))
struct s_mapply_unary {
  t_subexpression _subexpression;
  admse _name;
  int _name_isdefault : 2;
  p_adms _arg1;
  int _arg1_isdefault : 2;
};
char*adms_mapply_unary_uid (p_mapply_unary mymapply_unary);
p_mapply_unary adms_mapply_unary_new (admse myname,p_adms myarg1);
void adms_mapply_unary_free(p_mapply_unary mymapply_unary);
void adms_mapply_unary_valueto_name (p_mapply_unary mymapply_unary,admse _name);
void adms_mapply_unary_valueto_arg1 (p_mapply_unary mymapply_unary,p_adms _arg1);

/* ------- mapply_binary -------------- */
#define adms_mapply_binary(member) ((p_mapply_binary)(member))
struct s_mapply_binary {
  t_subexpression _subexpression;
  admse _name;
  int _name_isdefault : 2;
  p_adms _arg1;
  int _arg1_isdefault : 2;
  p_adms _arg2;
  int _arg2_isdefault : 2;
};
char*adms_mapply_binary_uid (p_mapply_binary mymapply_binary);
p_mapply_binary adms_mapply_binary_new (admse myname,p_adms myarg1,p_adms myarg2);
void adms_mapply_binary_free(p_mapply_binary mymapply_binary);
void adms_mapply_binary_valueto_name (p_mapply_binary mymapply_binary,admse _name);
void adms_mapply_binary_valueto_arg1 (p_mapply_binary mymapply_binary,p_adms _arg1);
void adms_mapply_binary_valueto_arg2 (p_mapply_binary mymapply_binary,p_adms _arg2);

/* ------- mapply_ternary -------------- */
#define adms_mapply_ternary(member) ((p_mapply_ternary)(member))
struct s_mapply_ternary {
  t_subexpression _subexpression;
  admse _name;
  int _name_isdefault : 2;
  p_adms _arg1;
  int _arg1_isdefault : 2;
  p_adms _arg2;
  int _arg2_isdefault : 2;
  p_adms _arg3;
  int _arg3_isdefault : 2;
};
char*adms_mapply_ternary_uid (p_mapply_ternary mymapply_ternary);
p_mapply_ternary adms_mapply_ternary_new (admse myname,p_adms myarg1,p_adms myarg2,p_adms myarg3);
void adms_mapply_ternary_free(p_mapply_ternary mymapply_ternary);
void adms_mapply_ternary_valueto_name (p_mapply_ternary mymapply_ternary,admse _name);
void adms_mapply_ternary_valueto_arg1 (p_mapply_ternary mymapply_ternary,p_adms _arg1);
void adms_mapply_ternary_valueto_arg2 (p_mapply_ternary mymapply_ternary,p_adms _arg2);
void adms_mapply_ternary_valueto_arg3 (p_mapply_ternary mymapply_ternary,p_adms _arg3);

/* ------- number -------------- */
#define adms_number(member) ((p_number)(member))
struct s_number {
  t_subexpression _subexpression;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  admse _scalingunit;
  int _scalingunit_isdefault : 2;
  admse _cast;
  int _cast_isdefault : 2;
};
char*adms_number_uid (p_number mynumber);
p_number adms_number_new (p_lexval mylexval);
void adms_number_free(p_number mynumber);
void adms_number_valueto_lexval (p_number mynumber,p_lexval _lexval);
void adms_number_valueto_scalingunit (p_number mynumber,admse _scalingunit);
void adms_number_valueto_cast (p_number mynumber,admse _cast);

/* ------- function -------------- */
#define adms_function(member) ((p_function)(member))
struct s_function {
  t_subexpression _subexpression;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  int _unique_id;
  int _unique_id_isdefault : 2;
  p_analogfunction _definition;
  int _definition_isdefault : 2;
  admse _class;
  int _class_isdefault : 2;
  p_slist _arguments;
  int _arguments_isdefault : 2;
};
char*adms_function_uid (p_function myfunction);
p_function adms_function_new (p_lexval mylexval,int myunique_id);
void adms_function_free(p_function myfunction);
void adms_function_valueto_lexval (p_function myfunction,p_lexval _lexval);
void adms_function_valueto_unique_id (p_function myfunction,int _unique_id);
void adms_function_valueto_definition (p_function myfunction,p_analogfunction _definition);
void adms_function_valueto_class (p_function myfunction,admse _class);
void adms_function_valueto_arguments (p_function myfunction,p_slist _arguments);

/* ------- variable -------------- */
#define adms_variable(member) ((p_variable)(member))
struct s_variable {
  t_subexpression _subexpression;
  p_variableprototype _prototype;
  int _prototype_isdefault : 2;
};
char*adms_variable_uid (p_variable myvariable);
p_variable adms_variable_new (p_variableprototype myprototype);
void adms_variable_free(p_variable myvariable);
void adms_variable_valueto_prototype (p_variable myvariable,p_variableprototype _prototype);

/* ------- array -------------- */
#define adms_array(member) ((p_array)(member))
struct s_array {
  t_subexpression _subexpression;
  p_variable _variable;
  int _variable_isdefault : 2;
  p_adms _index;
  int _index_isdefault : 2;
};
char*adms_array_uid (p_array myarray);
p_array adms_array_new (p_variable myvariable,p_adms myindex);
void adms_array_free(p_array myarray);
void adms_array_valueto_variable (p_array myarray,p_variable _variable);
void adms_array_valueto_index (p_array myarray,p_adms _index);

/* ------- probe -------------- */
#define adms_probe(member) ((p_probe)(member))
struct s_probe {
  t_subexpression _subexpression;
  p_module _module;
  int _module_isdefault : 2;
  p_branch _branch;
  int _branch_isdefault : 2;
  p_nature _nature;
  int _nature_isdefault : 2;
  admse _seen;
  int _seen_isdefault : 2;
  p_discipline _discipline;
  int _discipline_isdefault : 2;
  admse _grounded;
  int _grounded_isdefault : 2;
  p_source _source;
  int _source_isdefault : 2;
};
char*adms_probe_uid (p_probe myprobe);
p_probe adms_probe_new (p_module mymodule,p_branch mybranch,p_nature mynature);
void adms_probe_free(p_probe myprobe);
void adms_probe_valueto_module (p_probe myprobe,p_module _module);
void adms_probe_valueto_branch (p_probe myprobe,p_branch _branch);
void adms_probe_valueto_nature (p_probe myprobe,p_nature _nature);
void adms_probe_valueto_seen (p_probe myprobe,admse _seen);
void adms_probe_valueto_discipline (p_probe myprobe,p_discipline _discipline);
void adms_probe_valueto_grounded (p_probe myprobe,admse _grounded);
void adms_probe_valueto_source (p_probe myprobe,p_source _source);

/* ------- expression -------------- */
#define adms_expression(member) ((p_expression)(member))
struct s_expression {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_adms _tree;
  int _tree_isdefault : 2;
  char* _hasspecialnumber;
  int _hasspecialnumber_isdefault : 2;
  admse _hasVoltageDependentFunction;
  int _hasVoltageDependentFunction_isdefault : 2;
  admse _infinity;
  int _infinity_isdefault : 2;
  admse _TemperatureDependent;
  int _TemperatureDependent_isdefault : 2;
  admse _value;
  int _value_isdefault : 2;
  p_slist _function;
  int _function_isdefault : 2;
  p_slist _probe;
  int _probe_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
};
char*adms_expression_uid (p_expression myexpression);
p_expression adms_expression_new (p_module mymodule,p_adms mytree);
void adms_expression_free(p_expression myexpression);
void adms_expression_valueto_module (p_expression myexpression,p_module _module);
void adms_expression_valueto_tree (p_expression myexpression,p_adms _tree);
void adms_expression_valueto_hasspecialnumber (p_expression myexpression,const char* _hasspecialnumber);
void adms_expression_valueto_hasVoltageDependentFunction (p_expression myexpression,admse _hasVoltageDependentFunction);
void adms_expression_valueto_infinity (p_expression myexpression,admse _infinity);
void adms_expression_valueto_TemperatureDependent (p_expression myexpression,admse _TemperatureDependent);
void adms_expression_valueto_value (p_expression myexpression,admse _value);
void adms_expression_valueto_function (p_expression myexpression,p_slist _function);
void adms_expression_valueto_probe (p_expression myexpression,p_slist _probe);
void adms_expression_valueto_variable (p_expression myexpression,p_slist _variable);

/* ------- instance -------------- */
#define adms_instance(member) ((p_instance)(member))
struct s_instance {
  t_math _math;
  p_module _instantiator;
  int _instantiator_isdefault : 2;
  p_module _module;
  int _module_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_slist _terminal;
  int _terminal_isdefault : 2;
  p_slist _parameterset;
  int _parameterset_isdefault : 2;
};
char*adms_instance_uid (p_instance myinstance);
p_instance adms_instance_new (p_module myinstantiator,p_module mymodule,const char* myname);
void adms_instance_free(p_instance myinstance);
void adms_instance_valueto_instantiator (p_instance myinstance,p_module _instantiator);
void adms_instance_valueto_module (p_instance myinstance,p_module _module);
void adms_instance_valueto_name (p_instance myinstance,const char* _name);
void adms_instance_valueto_terminal (p_instance myinstance,p_slist _terminal);
void adms_instance_list_terminal_prepend_once_or_abort (p_instance mymyinstance,p_instancenode myterminal);
void adms_instance_valueto_parameterset (p_instance myinstance,p_slist _parameterset);
void adms_instance_list_parameterset_prepend_once_or_abort (p_instance mymyinstance,p_instanceparameter myparameterset);

/* ------- instanceparameter -------------- */
#define adms_instanceparameter(member) ((p_instanceparameter)(member))
struct s_instanceparameter {
  t_math _math;
  p_variableprototype _parameter;
  int _parameter_isdefault : 2;
  p_expression _value;
  int _value_isdefault : 2;
};
char*adms_instanceparameter_uid (p_instanceparameter myinstanceparameter);
p_instanceparameter adms_instanceparameter_new (p_variableprototype myparameter);
void adms_instanceparameter_free(p_instanceparameter myinstanceparameter);
void adms_instanceparameter_valueto_parameter (p_instanceparameter myinstanceparameter,p_variableprototype _parameter);
void adms_instanceparameter_valueto_value (p_instanceparameter myinstanceparameter,p_expression _value);

/* ------- instancenode -------------- */
#define adms_instancenode(member) ((p_instancenode)(member))
struct s_instancenode {
  t_math _math;
  p_node _nodefrominstantiator;
  int _nodefrominstantiator_isdefault : 2;
  p_node _nodefrommodule;
  int _nodefrommodule_isdefault : 2;
};
char*adms_instancenode_uid (p_instancenode myinstancenode);
p_instancenode adms_instancenode_new (p_node mynodefrominstantiator,p_node mynodefrommodule);
void adms_instancenode_free(p_instancenode myinstancenode);
void adms_instancenode_valueto_nodefrominstantiator (p_instancenode myinstancenode,p_node _nodefrominstantiator);
void adms_instancenode_valueto_nodefrommodule (p_instancenode myinstancenode,p_node _nodefrommodule);

/* ------- nilled -------------- */
#define adms_nilled(member) ((p_nilled)(member))
struct s_nilled {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
};
char*adms_nilled_uid (p_nilled mynilled);
p_nilled adms_nilled_new (p_module mymodule);
void adms_nilled_free(p_nilled mynilled);
void adms_nilled_valueto_module (p_nilled mynilled,p_module _module);
void adms_nilled_valueto_name (p_nilled mynilled,const char* _name);

/* ------- assignment -------------- */
#define adms_assignment(member) ((p_assignment)(member))
struct s_assignment {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_adms _lhs;
  int _lhs_isdefault : 2;
  p_expression _rhs;
  int _rhs_isdefault : 2;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_assignment_uid (p_assignment myassignment);
p_assignment adms_assignment_new (p_module mymodule,p_adms mylhs,p_expression myrhs,p_lexval mylexval);
void adms_assignment_free(p_assignment myassignment);
void adms_assignment_valueto_module (p_assignment myassignment,p_module _module);
void adms_assignment_valueto_lhs (p_assignment myassignment,p_adms _lhs);
void adms_assignment_valueto_rhs (p_assignment myassignment,p_expression _rhs);
void adms_assignment_valueto_lexval (p_assignment myassignment,p_lexval _lexval);
void adms_assignment_valueto_name (p_assignment myassignment,const char* _name);
void adms_assignment_valueto_attribute (p_assignment myassignment,p_slist _attribute);

/* ------- contribution -------------- */
#define adms_contribution(member) ((p_contribution)(member))
struct s_contribution {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_source _lhs;
  int _lhs_isdefault : 2;
  p_expression _rhs;
  int _rhs_isdefault : 2;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  p_branchalias _branchalias;
  int _branchalias_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  admse _whitenoise;
  int _whitenoise_isdefault : 2;
  admse _flickernoise;
  int _flickernoise_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
};
char*adms_contribution_uid (p_contribution mycontribution);
p_contribution adms_contribution_new (p_module mymodule,p_source mylhs,p_expression myrhs,p_lexval mylexval);
void adms_contribution_free(p_contribution mycontribution);
void adms_contribution_valueto_module (p_contribution mycontribution,p_module _module);
void adms_contribution_valueto_lhs (p_contribution mycontribution,p_source _lhs);
void adms_contribution_valueto_rhs (p_contribution mycontribution,p_expression _rhs);
void adms_contribution_valueto_lexval (p_contribution mycontribution,p_lexval _lexval);
void adms_contribution_valueto_branchalias (p_contribution mycontribution,p_branchalias _branchalias);
void adms_contribution_valueto_name (p_contribution mycontribution,const char* _name);
void adms_contribution_valueto_whitenoise (p_contribution mycontribution,admse _whitenoise);
void adms_contribution_valueto_flickernoise (p_contribution mycontribution,admse _flickernoise);
void adms_contribution_valueto_attribute (p_contribution mycontribution,p_slist _attribute);

/* ------- conditional -------------- */
#define adms_conditional(member) ((p_conditional)(member))
struct s_conditional {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_expression _if;
  int _if_isdefault : 2;
  p_adms _then;
  int _then_isdefault : 2;
  p_adms _else;
  int _else_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
};
char*adms_conditional_uid (p_conditional myconditional);
p_conditional adms_conditional_new (p_module mymodule,p_expression myif,p_adms mythen,p_adms myelse);
void adms_conditional_free(p_conditional myconditional);
void adms_conditional_valueto_module (p_conditional myconditional,p_module _module);
void adms_conditional_valueto_if (p_conditional myconditional,p_expression _if);
void adms_conditional_valueto_then (p_conditional myconditional,p_adms _then);
void adms_conditional_valueto_else (p_conditional myconditional,p_adms _else);
void adms_conditional_valueto_name (p_conditional myconditional,const char* _name);

/* ------- forloop -------------- */
#define adms_forloop(member) ((p_forloop)(member))
struct s_forloop {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_assignment _initial;
  int _initial_isdefault : 2;
  p_expression _condition;
  int _condition_isdefault : 2;
  p_assignment _update;
  int _update_isdefault : 2;
  p_adms _forblock;
  int _forblock_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
};
char*adms_forloop_uid (p_forloop myforloop);
p_forloop adms_forloop_new (p_module mymodule,p_assignment myinitial,p_expression mycondition,p_assignment myupdate,p_adms myforblock);
void adms_forloop_free(p_forloop myforloop);
void adms_forloop_valueto_module (p_forloop myforloop,p_module _module);
void adms_forloop_valueto_initial (p_forloop myforloop,p_assignment _initial);
void adms_forloop_valueto_condition (p_forloop myforloop,p_expression _condition);
void adms_forloop_valueto_update (p_forloop myforloop,p_assignment _update);
void adms_forloop_valueto_forblock (p_forloop myforloop,p_adms _forblock);
void adms_forloop_valueto_name (p_forloop myforloop,const char* _name);

/* ------- whileloop -------------- */
#define adms_whileloop(member) ((p_whileloop)(member))
struct s_whileloop {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_expression _while;
  int _while_isdefault : 2;
  p_adms _whileblock;
  int _whileblock_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
};
char*adms_whileloop_uid (p_whileloop mywhileloop);
p_whileloop adms_whileloop_new (p_module mymodule,p_expression mywhile,p_adms mywhileblock);
void adms_whileloop_free(p_whileloop mywhileloop);
void adms_whileloop_valueto_module (p_whileloop mywhileloop,p_module _module);
void adms_whileloop_valueto_while (p_whileloop mywhileloop,p_expression _while);
void adms_whileloop_valueto_whileblock (p_whileloop mywhileloop,p_adms _whileblock);
void adms_whileloop_valueto_name (p_whileloop mywhileloop,const char* _name);

/* ------- case -------------- */
#define adms_case(member) ((p_case)(member))
struct s_case {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_expression _case;
  int _case_isdefault : 2;
  char* _name;
  int _name_isdefault : 2;
  p_slist _caseitem;
  int _caseitem_isdefault : 2;
};
char*adms_case_uid (p_case mycase);
p_case adms_case_new (p_module mymodule,p_expression mycase);
void adms_case_free(p_case mycase);
void adms_case_valueto_module (p_case mycase,p_module _module);
void adms_case_valueto_case (p_case mycase,p_expression _case);
void adms_case_valueto_name (p_case mycase,const char* _name);
void adms_case_valueto_caseitem (p_case mycase,p_slist _caseitem);

/* ------- caseitem -------------- */
#define adms_caseitem(member) ((p_caseitem)(member))
struct s_caseitem {
  t_math _math;
  p_adms _code;
  int _code_isdefault : 2;
  admse _defaultcase;
  int _defaultcase_isdefault : 2;
  p_slist _condition;
  int _condition_isdefault : 2;
};
char*adms_caseitem_uid (p_caseitem mycaseitem);
p_caseitem adms_caseitem_new (p_adms mycode);
void adms_caseitem_free(p_caseitem mycaseitem);
void adms_caseitem_valueto_code (p_caseitem mycaseitem,p_adms _code);
void adms_caseitem_valueto_defaultcase (p_caseitem mycaseitem,admse _defaultcase);
void adms_caseitem_valueto_condition (p_caseitem mycaseitem,p_slist _condition);

/* ------- blockvariable -------------- */
#define adms_blockvariable(member) ((p_blockvariable)(member))
struct s_blockvariable {
  t_math _math;
  p_block _block;
  int _block_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
};
char*adms_blockvariable_uid (p_blockvariable myblockvariable);
p_blockvariable adms_blockvariable_new (p_block myblock);
void adms_blockvariable_free(p_blockvariable myblockvariable);
void adms_blockvariable_valueto_block (p_blockvariable myblockvariable,p_block _block);
void adms_blockvariable_valueto_variable (p_blockvariable myblockvariable,p_slist _variable);
void adms_blockvariable_list_variable_prepend_once_or_abort (p_blockvariable mymyblockvariable,p_variable myvariable);

/* ------- block -------------- */
#define adms_block(member) ((p_block)(member))
struct s_block {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_lexval _lexval;
  int _lexval_isdefault : 2;
  p_block _block;
  int _block_isdefault : 2;
  p_slist _item;
  int _item_isdefault : 2;
  p_slist _attribute;
  int _attribute_isdefault : 2;
  p_slist _variable;
  int _variable_isdefault : 2;
  p_slist _probe;
  int _probe_isdefault : 2;
};
char*adms_block_uid (p_block myblock);
p_block adms_block_new (p_module mymodule,p_lexval mylexval,p_block myblock,p_slist myitem);
void adms_block_free(p_block myblock);
void adms_block_valueto_module (p_block myblock,p_module _module);
void adms_block_valueto_lexval (p_block myblock,p_lexval _lexval);
void adms_block_valueto_block (p_block myblock,p_block _block);
void adms_block_valueto_item (p_block myblock,p_slist _item);
void adms_block_valueto_attribute (p_block myblock,p_slist _attribute);
void adms_block_valueto_variable (p_block myblock,p_slist _variable);
void adms_block_list_variable_prepend_once_or_abort (p_block mymyblock,p_variableprototype myvariable);
void adms_block_valueto_probe (p_block myblock,p_slist _probe);

/* ------- callfunction -------------- */
#define adms_callfunction(member) ((p_callfunction)(member))
struct s_callfunction {
  t_math _math;
  p_module _module;
  int _module_isdefault : 2;
  p_function _function;
  int _function_isdefault : 2;
};
char*adms_callfunction_uid (p_callfunction mycallfunction);
p_callfunction adms_callfunction_new (p_module mymodule,p_function myfunction);
void adms_callfunction_free(p_callfunction mycallfunction);
void adms_callfunction_valueto_module (p_callfunction mycallfunction,p_module _module);
void adms_callfunction_valueto_function (p_callfunction mycallfunction,p_function _function);

/* ------- evaluation -------------- */
#define adms_evaluation(member) ((p_evaluation)(member))
struct s_evaluation {
  t_adms _adms;
  p_slist _variable;
  int _variable_isdefault : 2;
};
char*adms_evaluation_uid (p_evaluation myevaluation);
p_evaluation adms_evaluation_new (void);
void adms_evaluation_free(p_evaluation myevaluation);
void adms_evaluation_valueto_variable (p_evaluation myevaluation,p_slist _variable);

/* ------- text -------------- */
#define adms_text(member) ((p_text)(member))
struct s_text {
  t_adms _adms;
  p_transform _transform;
  char* _value;
  char* _aname;
  int _admse;
  p_slist _token;
};
char*adms_text_uid (p_text mytext);
p_text adms_text_new (p_transform mytransform,const char* myvalue);

/* ------- path -------------- */
#define adms_path(member) ((p_path)(member))
struct s_path {
  t_adms _adms;
  p_transform _transform;
  p_text _text;
  char* _aname;
  char* _avalue;
  p_transform _template;
  int _keeplist;
  char* _callbackname;
  void* _callback;
  p_slist _bar;
  p_slist _arg;
  p_slist _u;
  p_slist _b;
  p_slist _c;
};
char*adms_path_uid (p_path mypath);
p_path adms_path_new (p_transform mytransform,p_text mytext);

/* ------- ptraverse -------------- */
#define adms_ptraverse(member) ((p_ptraverse)(member))
struct s_ptraverse {
  t_adms _adms;
  p_transform _transform;
  p_slist _admst;
  p_slist _alladmst;
  p_slist _aliasadmst;
  int _position;
  p_admst _a1;
  p_admst _an;
};
char*adms_ptraverse_uid (p_ptraverse myptraverse);
p_ptraverse adms_ptraverse_new (p_transform mytransform);
void adms_ptraverse_free(p_ptraverse myptraverse);
void adms_ptraverse_valueto_transform (p_ptraverse myptraverse,p_transform _transform);
void adms_ptraverse_valueto_admst (p_ptraverse myptraverse,p_slist _admst);
void adms_ptraverse_valueto_alladmst (p_ptraverse myptraverse,p_slist _alladmst);
void adms_ptraverse_valueto_aliasadmst (p_ptraverse myptraverse,p_slist _aliasadmst);
void adms_ptraverse_valueto_position (p_ptraverse myptraverse,int _position);
void adms_ptraverse_valueto_a1 (p_ptraverse myptraverse,p_admst _a1);
void adms_ptraverse_valueto_an (p_ptraverse myptraverse,p_admst _an);

/* ------- pparse -------------- */
#define adms_pparse(member) ((p_pparse)(member))
struct s_pparse {
  t_adms _adms;
  p_transform _transform;
  char* _aname;
  char* _value;
  p_path _path;
  p_text _text;
  const char* _position;
  const char* _tkstart;
  int _tklen;
  admse _tkid;
};
char*adms_pparse_uid (p_pparse mypparse);
p_pparse adms_pparse_new (p_transform mytransform,const char* myaname,const char* myvalue);
void adms_pparse_free(p_pparse mypparse);
void adms_pparse_valueto_transform (p_pparse mypparse,p_transform _transform);
void adms_pparse_valueto_aname (p_pparse mypparse,const char* _aname);
void adms_pparse_valueto_value (p_pparse mypparse,const char* _value);
void adms_pparse_valueto_path (p_pparse mypparse,p_path _path);
void adms_pparse_valueto_text (p_pparse mypparse,p_text _text);
void adms_pparse_valueto_position (p_pparse mypparse,const char* _position);
void adms_pparse_valueto_tkstart (p_pparse mypparse,const char* _tkstart);
void adms_pparse_valueto_tklen (p_pparse mypparse,int _tklen);
void adms_pparse_valueto_tkid (p_pparse mypparse,admse _tkid);

/* ------- admst -------------- */
#define adms_admst(member) ((p_admst)(member))
struct s_admst {
  t_adms _adms;
  p_admst _previous;
  p_admst _previouspath;
  admse _pseudo;
  union admsu _item;
  void* _valueto;
  int _position;
  int _count;
  int _hasnewbasicstring;
  p_admst _original;
  int _refd;
  int _true;
  p_admst _preva;
  p_admst _nexta;
  admse _selected;
};
char*adms_admst_uid (p_admst myadmst);
p_admst adms_admst_new (p_admst myprevious,p_admst mypreviouspath,admse mypseudo);
void adms_admst_free(p_admst myadmst);
void adms_admst_valueto_previous (p_admst myadmst,p_admst _previous);
void adms_admst_valueto_previouspath (p_admst myadmst,p_admst _previouspath);
void adms_admst_valueto_pseudo (p_admst myadmst,admse _pseudo);
void adms_admst_valueto_item (p_admst myadmst,p_adms _item);
void adms_admst_valueto_valueto (p_admst myadmst,void* _valueto);
void adms_admst_valueto_position (p_admst myadmst,int _position);
void adms_admst_valueto_count (p_admst myadmst,int _count);
void adms_admst_valueto_hasnewbasicstring (p_admst myadmst,int _hasnewbasicstring);
void adms_admst_valueto_original (p_admst myadmst,p_admst _original);
void adms_admst_valueto_refd (p_admst myadmst,int _refd);
void adms_admst_valueto_true (p_admst myadmst,int _true);
void adms_admst_valueto_preva (p_admst myadmst,p_admst _preva);
void adms_admst_valueto_nexta (p_admst myadmst,p_admst _nexta);
void adms_admst_valueto_selected (p_admst myadmst,admse _selected);

/* ------- transform -------------- */
#define adms_transform(member) ((p_transform)(member))
struct s_transform {
  t_adms _adms;
  char* _fullfilename;
  char* _basefilename;
  int _l;
  char* _name;
  p_transform _parent;
  void* _callback;
  char* _id;
  p_path _pathselect;
  p_path _pathpath;
  p_path _pathinto;
  p_path _pathtest;
  p_path _pathlist;
  p_text _textselect;
  p_text _textdatatype;
  p_text _textmatch;
  p_text _textrequired;
  p_text _textseparator;
  p_text _textfrom;
  p_text _textto;
  p_text _textlist;
  p_text _textname;
  p_text _textformat;
  p_text _textfile;
  p_text _textversion;
  p_text _textonduplicate;
  p_text _textprobe;
  p_text _textstring;
  p_slist _templates;
  p_slist _textarguments;
  p_path _pathoncompare;
  p_slist _pathinputs;
  p_slist _attribute;
  p_slist _children;
};
char*adms_transform_uid (p_transform mytransform);
p_transform adms_transform_new (const char* myfullfilename,const char* mybasefilename,int myl,const char* myname,p_transform myparent);
void adms_transform_free(p_transform mytransform);
void adms_transform_valueto_fullfilename (p_transform mytransform,const char* _fullfilename);
void adms_transform_valueto_basefilename (p_transform mytransform,const char* _basefilename);
void adms_transform_valueto_l (p_transform mytransform,int _l);
void adms_transform_valueto_name (p_transform mytransform,const char* _name);
void adms_transform_valueto_parent (p_transform mytransform,p_transform _parent);
void adms_transform_valueto_callback (p_transform mytransform,void* _callback);
void adms_transform_valueto_id (p_transform mytransform,const char* _id);
void adms_transform_valueto_pathselect (p_transform mytransform,p_path _pathselect);
void adms_transform_valueto_pathpath (p_transform mytransform,p_path _pathpath);
void adms_transform_valueto_pathinto (p_transform mytransform,p_path _pathinto);
void adms_transform_valueto_pathtest (p_transform mytransform,p_path _pathtest);
void adms_transform_valueto_pathlist (p_transform mytransform,p_path _pathlist);
void adms_transform_valueto_textselect (p_transform mytransform,p_text _textselect);
void adms_transform_valueto_textdatatype (p_transform mytransform,p_text _textdatatype);
void adms_transform_valueto_textmatch (p_transform mytransform,p_text _textmatch);
void adms_transform_valueto_textrequired (p_transform mytransform,p_text _textrequired);
void adms_transform_valueto_textseparator (p_transform mytransform,p_text _textseparator);
void adms_transform_valueto_textfrom (p_transform mytransform,p_text _textfrom);
void adms_transform_valueto_textto (p_transform mytransform,p_text _textto);
void adms_transform_valueto_textlist (p_transform mytransform,p_text _textlist);
void adms_transform_valueto_textname (p_transform mytransform,p_text _textname);
void adms_transform_valueto_textformat (p_transform mytransform,p_text _textformat);
void adms_transform_valueto_textfile (p_transform mytransform,p_text _textfile);
void adms_transform_valueto_textversion (p_transform mytransform,p_text _textversion);
void adms_transform_valueto_textonduplicate (p_transform mytransform,p_text _textonduplicate);
void adms_transform_valueto_textprobe (p_transform mytransform,p_text _textprobe);
void adms_transform_valueto_textstring (p_transform mytransform,p_text _textstring);
void adms_transform_valueto_templates (p_transform mytransform,p_slist _templates);
void adms_transform_valueto_textarguments (p_transform mytransform,p_slist _textarguments);
void adms_transform_valueto_pathoncompare (p_transform mytransform,p_path _pathoncompare);
void adms_transform_valueto_pathinputs (p_transform mytransform,p_slist _pathinputs);
void adms_transform_valueto_attribute (p_transform mytransform,p_slist _attribute);
void adms_transform_valueto_children (p_transform mytransform,p_slist _children);

/* ------- itransform -------------- */
#define adms_itransform(member) ((p_itransform)(member))
struct s_itransform {
  t_adms _adms;
  p_transform _template;
  p_transform _originalcall;
  p_slist _variable;
  p_slist _return;
};
char*adms_itransform_uid (p_itransform myitransform);
p_itransform adms_itransform_new (p_transform mytemplate);
void adms_itransform_free(p_itransform myitransform);
void adms_itransform_valueto_template (p_itransform myitransform,p_transform _template);
void adms_itransform_valueto_originalcall (p_itransform myitransform,p_transform _originalcall);
void adms_itransform_valueto_variable (p_itransform myitransform,p_slist _variable);
void adms_itransform_valueto_return (p_itransform myitransform,p_slist _return);

/* ------- return -------------- */
#define adms_return(member) ((p_return)(member))
struct s_return {
  t_adms _adms;
  char* _name;
  char* _value;
};
char*adms_return_uid (p_return myreturn);
p_return adms_return_new (const char* myname,const char* myvalue);
void adms_return_free(p_return myreturn);
void adms_return_valueto_name (p_return myreturn,const char* _name);
void adms_return_valueto_value (p_return myreturn,const char* _value);

/* ------- attribute -------------- */
#define adms_attribute(member) ((p_attribute)(member))
struct s_attribute {
  t_adms _adms;
  char* _name;
  int _name_isdefault : 2;
  p_adms _value;
  int _value_isdefault : 2;
};
char*adms_attribute_uid (p_attribute myattribute);
p_attribute adms_attribute_new (const char* myname);
void adms_attribute_free(p_attribute myattribute);
void adms_attribute_valueto_name (p_attribute myattribute,const char* _name);
void adms_attribute_valueto_value (p_attribute myattribute,p_adms _value);

/* ------- admstvariable -------------- */
#define adms_admstvariable(member) ((p_admstvariable)(member))
struct s_admstvariable {
  t_adms _adms;
  char* _name;
  p_slist _value;
};
char*adms_admstvariable_uid (p_admstvariable myadmstvariable);
p_admstvariable adms_admstvariable_new (const char* myname);
void adms_admstvariable_free(p_admstvariable myadmstvariable);
void adms_admstvariable_valueto_name (p_admstvariable myadmstvariable,const char* _name);
void adms_admstvariable_valueto_value (p_admstvariable myadmstvariable,p_slist _value);

/* ------- lexval -------------- */
#define adms_lexval(member) ((p_lexval)(member))
struct s_lexval {
  t_adms _adms;
  char* _string;
  int _string_isdefault : 2;
  char* _f;
  int _f_isdefault : 2;
  int _l;
  int _l_isdefault : 2;
  int _c;
  int _c_isdefault : 2;
};
char*adms_lexval_uid (p_lexval mylexval);
p_lexval adms_lexval_new (const char* mystring,const char* myf,int myl,int myc);
void adms_lexval_free(p_lexval mylexval);
void adms_lexval_valueto_string (p_lexval mylexval,const char* _string);
void adms_lexval_valueto_f (p_lexval mylexval,const char* _f);
void adms_lexval_valueto_l (p_lexval mylexval,int _l);
void adms_lexval_valueto_c (p_lexval mylexval,int _c);

/* ------- yaccval -------------- */
#define adms_yaccval(member) ((p_yaccval)(member))
struct s_yaccval {
  t_adms _adms;
  char* _filename;
  p_adms _usrdata;
};
char*adms_yaccval_uid (p_yaccval myyaccval);
p_yaccval adms_yaccval_new (const char* myfilename);
void adms_yaccval_free(p_yaccval myyaccval);
void adms_yaccval_valueto_filename (p_yaccval myyaccval,const char* _filename);
void adms_yaccval_valueto_usrdata (p_yaccval myyaccval,p_adms _usrdata);

admse ns_strtoe (const char* tk);
char* ns_etostr (admse e);
p_new adms_admsxml_new (p_ktransform mytransform,const char* ename);
p_cmp adms_admsxml_cmp (p_kadmst myadmst);
#endif /* adms_h */
