
const char * disciplines_vams =
"/*\n"
"  Copyright C 2007 Accellera Organization, Inc.\n"
"  Standard definitions\n"
"  This file contains the standard definition package disciplines.vams for Verilog-AMS HDL.\n"
"*/\n"
"\n"
"`ifdef DISCIPLINES_VAMS\n"
"`else\n"
"`define DISCIPLINES_VAMS 1\n"
"//\n"
"// Natures and Disciplines\n"
"//\n"
"discipline logic\n"
"  domain discrete;\n"
"enddiscipline\n"
"/*\n"
"* Default absolute tolerances may be overridden by setting the\n"
"* appropriate _ABSTOL prior to including this file\n"
"*/\n"
"// Electrical\n"
"// Current in amperes\n"
"nature Current\n"
"  units = \"A\";\n"
"  access = I;\n"
"  idt_nature = Charge;\n"
"`ifdef CURRENT_ABSTOL\n"
"  abstol = `CURRENT_ABSTOL;\n"
"`else\n"
"  abstol = 1e-12;\n"
"`endif\n"
"endnature\n"
"// Charge in coulombs\n"
"nature Charge\n"
"  units = \"coul\";\n"
"  access = Q;\n"
"  ddt_nature = Current;\n"
"`ifdef CHARGE_ABSTOL\n"
"  abstol = `CHARGE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-14;\n"
"`endif\n"
"endnature\n"
"// Potential in volts\n"
"nature Voltage\n"
"  units = \"V\";\n"
"  access = V;\n"
"  idt_nature = Flux;\n"
"`ifdef VOLTAGE_ABSTOL\n"
"  abstol = `VOLTAGE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Flux in Webers\n"
"nature Flux\n"
"  units = \"Wb\";\n"
"  access = Phi;\n"
"  ddt_nature = Voltage;\n"
"`ifdef FLUX_ABSTOL\n"
"  abstol = `FLUX_ABSTOL;\n"
"`else\n"
"  abstol = 1e-9;\n"
"`endif\n"
"endnature\n"
"// Conductance in Siemens\n"
"nature Conductance\n"
"  units = \"S\";\n"
"  access = G;\n"
"endnature\n"
"// Resistance in Ohms\n"
"nature Resistance\n"
"  units = \"ohms\";\n"
"  access = R;\n"
"endnature\n"
"// Capacitance in Farads\n"
"nature Capacitance\n"
"  units = \"F\";\n"
"  access = C;\n"
"endnature\n"
"// Conservative discipline\n"
"discipline electrical\n"
"  potential Voltage;\n"
"  flow Current;\n"
"  flow Conductance;\n"
"  flow Resistance;\n"
"  flow Capacitance;\n"
"enddiscipline\n"
"// Signal flow disciplines\n"
"discipline voltage\n"
"  potential Voltage;\n"
"enddiscipline\n"
"discipline current\n"
"  potential Current;\n"
"enddiscipline\n"
"// Thermal\n"
"// Temperature in Kelvin\n"
"nature Temperature\n"
"  units = \"K\";\n"
"  access = Temp;\n"
"`ifdef TEMPERATURE_ABSTOL\n"
"  abstol = `TEMPERATURE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-4;\n"
"`endif\n"
"endnature\n"
"// Power in Watts\n"
"nature Power\n"
"  units = \"W\";\n"
"  access = Pwr;\n"
"`ifdef POWER_ABSTOL\n"
"  abstol = `POWER_ABSTOL;\n"
"`else\n"
"  abstol = 1e-9;\n"
"`endif\n"
"endnature\n"
"// Conservative discipline\n"
"discipline thermal\n"
"  potential Temperature;\n"
"  flow Power;\n"
"enddiscipline\n"
"`endif\n";
