/*
 * object.cpp - generic object class implementation
 *
 * Copyright (C) 2003, 2004, 2005, 2006, 2008 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: object.cpp,v 1.15 2008/02/18 18:03:55 ela Exp $
 *
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "logging.h"
#include "complex.h"
#include "object.h"


// Constructor creates an unnamed instance of the object class.
object::object () {
  name = NULL;
  prev = next = NULL;
}

// This constructor creates a named instance of the object class.
object::object (const char * n) {
  name = _strdup (n);
  prev = next = NULL;
}

// Destructor deletes an instance of the object class.
object::~object () {
  if (name) free (name);
}

// Sets the name of the object.
void object::setName (const char * n) {
  if (name) free (name);
  name = n ? _strdup (n) : NULL;

  char c;
  char *p = name;
  while((c=*(p++)) != 0) {
    if((c >= '0') && (c <= 'z')) {
      if(c <= '9')
        continue;
      if(c >= 'a')
        continue;
      if((c >= 'A') && (c <= 'Z'))
        continue;
    }
    *(p-1) = '_';
  }
}

// Returns the name of the object.
char * object::getName (void) {
  return name;
}
