/*
 * qucsdefs.h - netlist definitions for the Qucs netlists
 *
 * Copyright (C) 2004, 2005, 2006, 2007, 2008 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: qucsdefs.h,v 1.85 2008/03/02 11:42:30 ela Exp $
 *
 */

#ifndef __QUCSDEFS_H__
#define __QUCSDEFS_H__

// List of available components.
struct define_t qucs_definition_available[] =
{
  /* dc analysis */
  // !!!! This MUST be the first one !!!!
  { "DC", 0, PROP_ACTION,
    { { "reltol", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "abstol", PROP_REAL, { 1e-6, PROP_NO_STR } },
      { "MaxIter", PROP_INT, { 300, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* resistor */
  { "R", 2, PROP_COMPONENT, 
    { { "R", PROP_REAL, { 50, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Tc1", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tc2", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR } },
      PROP_NO_PROP },
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* inductor */
  { "L", 2, PROP_COMPONENT,
    { { "L", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "R", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "I", PROP_STR, { PROP_NO_VAL, "" } },
      PROP_NO_PROP },
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* capacitor */
  { "C", 2, PROP_COMPONENT,
    { { "C", PROP_REAL, { 1e-12, PROP_NO_STR } },
      { "G", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "V", PROP_STR, { PROP_NO_VAL, "" } },
      PROP_NO_PROP },
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* multiple mutual inductors */
  { "MUTn", PROP_NODES, PROP_COMPONENT,
    { { "coils", PROP_INT, { 150, PROP_NO_STR } },
      { "L2", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "k", PROP_REAL, { 0.9, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30, 30,-30, 30,-30, 30,-30, 30,-30, 30,-30, 30,-30, 30,-30, 30}
  },
  /* voltage controlled current source */
  { "VCCS", 4, PROP_COMPONENT,
    { { "G", PROP_REAL, { 1, PROP_NO_STR } },
      { "T", PROP_REAL, { 0, PROP_NO_STR } }, PROP_NO_PROP },
      {-30,30,30,-30,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,-30,30,30,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* current controlled current source */
  { "CCCS", 4, PROP_COMPONENT,
    { { "G", PROP_REAL, { 1, PROP_NO_STR } },
      { "T", PROP_REAL, { 0, PROP_NO_STR } }, PROP_NO_PROP },
      {-30,30,30,-30,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,-30,30,30,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* voltage controlled voltage source */
  { "VCVS", 4, PROP_COMPONENT,
    { { "G", PROP_REAL, { 1, PROP_NO_STR } },
      { "T", PROP_REAL, { 0, PROP_NO_STR } }, PROP_NO_PROP },
      {-30,30,30,-30,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,-30,30,30,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* current controlled voltage source */
  { "CCVS", 4, PROP_COMPONENT,
    { { "G", PROP_REAL, { 1, PROP_NO_STR } },
      { "T", PROP_REAL, { 0, PROP_NO_STR } }, PROP_NO_PROP },
      {-30,30,30,-30,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,-30,30,30,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* DC voltage source */
  { "Vdc", 2, PROP_COMPONENT,
    { { "U", PROP_REAL, { 1, PROP_NO_STR } }, PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* DC current source */
  { "Idc", 2, PROP_COMPONENT,
    { { "I", PROP_REAL, { 1e-3, PROP_NO_STR } }, PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* AC voltage source */
  { "Vac", 2, PROP_COMPONENT,
    { { "U", PROP_REAL, { 1, PROP_NO_STR } },
      { "freq", PROP_REAL, { 1e9, PROP_NO_STR } },
      { "Phase", PROP_REAL, { 0, PROP_NO_STR } },
      { "Theta", PROP_REAL, { 0, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* AC current source */
  { "Iac", 2, PROP_COMPONENT,
    { { "I", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "freq", PROP_REAL, { 1e9, PROP_NO_STR } },
      { "Phase", PROP_REAL, { 0, PROP_NO_STR } },
      { "Theta", PROP_REAL, { 0, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* pulse voltage source */
  { "Vpulse", 2, PROP_COMPONENT,
    { { "U1", PROP_REAL, { 0, PROP_NO_STR } },
      { "U2", PROP_REAL, { 1, PROP_NO_STR } },
      { "T1", PROP_REAL, { 0, PROP_NO_STR } },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* pulse current source */
  { "Ipulse", 2, PROP_COMPONENT,
    { { "I1", PROP_REAL, { 0, PROP_NO_STR } },
      { "I2", PROP_REAL, { 1, PROP_NO_STR } },
      { "T1", PROP_REAL, { 0, PROP_NO_STR } },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* rectangular pulse voltage source */
  { "Vrect", 2, PROP_COMPONENT,
    { { "UH", PROP_REAL, { 1, PROP_NO_STR } },
      { "UL", PROP_REAL, { 0, PROP_NO_STR } },
      { "TH", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "TL", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Td", PROP_REAL, { 0, PROP_NO_STR } },
      { "type", PROP_STR, { PROP_NO_VAL, "high low" } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* rectangular pulse current source */
  { "Irect", 2, PROP_COMPONENT,
    { { "IH", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "IL", PROP_REAL, { 0, PROP_NO_STR } },
      { "TH", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "TL", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR } },
      { "Td", PROP_REAL, { 0, PROP_NO_STR } },
      { "type", PROP_STR, { PROP_NO_VAL, "high low" } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* time controlled switch */
  { "Switch", 2, PROP_COMPONENT,
    { { "init", PROP_STR, { PROP_NO_VAL, "off" } },
      { "time", PROP_LIST, { 1e-9, PROP_NO_STR } },
      { "Ron", PROP_REAL, { 0, PROP_NO_STR } },
      { "Roff", PROP_REAL, { 1e12, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* relais */
  { "Relais", 4, PROP_COMPONENT,
    { { "Vt", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Vh", PROP_REAL, { 0.1, PROP_NO_STR } },
      { "Ron", PROP_REAL, { 0, PROP_NO_STR } },
      { "Roff", PROP_REAL, { 1e12, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* ideal 4-terminal transmission line */
  { "TLIN4P", 4, PROP_COMPONENT,
    { { "Z", PROP_REAL, { 50, PROP_NO_STR } }, 
      { "L", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Alpha", PROP_REAL, { 1, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* diode */
  { "Diode", 2, PROP_COMPONENT,
    { { "Is", PROP_REAL, { 1e-14, PROP_NO_STR } },
      { "N", PROP_REAL, { 1, PROP_NO_STR } },
      { "Cj0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "M", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Vj", PROP_REAL, { 0.7, PROP_NO_STR } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Cp", PROP_REAL, { 0, PROP_NO_STR } },
      { "Isr", PROP_REAL, { 0, PROP_NO_STR } },
      { "Nr", PROP_REAL, { 2, PROP_NO_STR } },
      { "Rs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tt", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ikf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Af", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR } },
      { "Bv", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ibv", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR } },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR } },
      { "Tbv", PROP_REAL, { 0, PROP_NO_STR } },
      { "Trs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ttt1", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ttt2", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tm1", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tm2", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Area", PROP_REAL, { 1, PROP_NO_STR } },
      { "EgTA", PROP_REAL, { 7.02e-4, PROP_NO_STR } },
      { "EgTB", PROP_REAL, { 1108.0, PROP_NO_STR } },
      PROP_NO_PROP },
      {30,-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* jfet */
  { "JFET", 3, PROP_COMPONENT,
    { { "Type", PROP_STR, { PROP_NO_VAL, "nfet" } },
      { "Vt0", PROP_REAL, { -2, PROP_NO_STR } },
      { "Beta", PROP_REAL, { 1e-4, PROP_NO_STR } },
      { "Lambda", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rd", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Is", PROP_REAL, { 1e-14, PROP_NO_STR } },
      { "N", PROP_REAL, { 1, PROP_NO_STR } },
      { "Isr", PROP_REAL, { 1e-14, PROP_NO_STR } },
      { "Nr", PROP_REAL, { 2, PROP_NO_STR } },
      { "Cgs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cgd", PROP_REAL, { 0, PROP_NO_STR } },
      { "Pb", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "M", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Af", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR } },
      { "Vt0tc", PROP_REAL, { 0, PROP_NO_STR } },
      { "Betatce", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Area", PROP_REAL, { 1, PROP_NO_STR } },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR } },
      { "EgTA", PROP_REAL, { 7.02e-4, PROP_NO_STR } },
      { "EgTB", PROP_REAL, { 1108.0, PROP_NO_STR } },
      PROP_NO_PROP },
      {-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* sgp bjt */
  { "BJT", 4, PROP_COMPONENT,
    { { "Type", PROP_STR, { PROP_NO_VAL, "npn" } },
      { "Is", PROP_REAL, { 1e-16, PROP_NO_STR } },
      { "Nf", PROP_REAL, { 1, PROP_NO_STR } },
      { "Nr", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ikf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ikr", PROP_REAL, { 0, PROP_NO_STR } },
      { "Vaf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Var", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ise", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ne", PROP_REAL, { 1.5, PROP_NO_STR } },
      { "Isc", PROP_REAL, { 0, PROP_NO_STR } },
      { "Nc", PROP_REAL, { 2, PROP_NO_STR } },
      { "Bf", PROP_REAL, { 100, PROP_NO_STR } },
      { "Br", PROP_REAL, { 1, PROP_NO_STR } },
      { "Rbm", PROP_REAL, { 0, PROP_NO_STR } },
      { "IRb", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rc", PROP_REAL, { 0, PROP_NO_STR } },
      { "Re", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rb", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cje", PROP_REAL, { 0, PROP_NO_STR } },
      { "Vje", PROP_REAL, { 0.75, PROP_NO_STR } },
      { "Mje", PROP_REAL, { 0.33, PROP_NO_STR } },
      { "Cjc", PROP_REAL, { 0, PROP_NO_STR } },
      { "Vjc", PROP_REAL, { 0.75, PROP_NO_STR } },
      { "Mjc", PROP_REAL, { 0.33, PROP_NO_STR } },
      { "Xcjc", PROP_REAL, { 1, PROP_NO_STR } },
      { "Cjs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Vjs", PROP_REAL, { 0.75, PROP_NO_STR } },
      { "Mjs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Tf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Xtf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Vtf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Itf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tr", PROP_REAL, { 0, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Af", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR } },
      { "Kb", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ab", PROP_REAL, { 1, PROP_NO_STR } },
      { "Fb", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ptf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Xtb", PROP_REAL, { 0, PROP_NO_STR } },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR } },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Area", PROP_REAL, { 1, PROP_NO_STR } },
      { "EgTA", PROP_REAL, { 7.02e-4, PROP_NO_STR } },
      { "EgTB", PROP_REAL, { 1108.0, PROP_NO_STR } },
      PROP_NO_PROP },
      {-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* fet: level 1 */
  { "MOSFET", 4, PROP_COMPONENT,
    { { "Type", PROP_STR, { PROP_NO_VAL, "nfet" } },
      { "Vt0", PROP_REAL, { 0, PROP_NO_STR } },
      { "Kp", PROP_REAL, { 2e-5, PROP_NO_STR } },
      { "Gamma", PROP_REAL, { 0, PROP_NO_STR } },
      { "Phi", PROP_REAL, { 0.6, PROP_NO_STR } },
      { "Lambda", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rd", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Rg", PROP_REAL, { 0, PROP_NO_STR } },
      { "Is", PROP_REAL, { 1e-14, PROP_NO_STR } },
      { "N", PROP_REAL, { 1, PROP_NO_STR } },
      { "W", PROP_REAL, { 100e-6, PROP_NO_STR } },
      { "L", PROP_REAL, { 100e-6, PROP_NO_STR } },
      { "Ld", PROP_REAL, { 0, PROP_NO_STR } },
      { "Tox", PROP_REAL, { 1e-7, PROP_NO_STR } },
      { "Cgso", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cgdo", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cgbo", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cbd", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cbs", PROP_REAL, { 0, PROP_NO_STR } },
      { "Pb", PROP_REAL, { 0.8, PROP_NO_STR } },
      { "Mj", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "Cjsw", PROP_REAL, { 0, PROP_NO_STR } },
      { "Mjsw", PROP_REAL, { 0.33, PROP_NO_STR } },
      { "Tt", PROP_REAL, { 0, PROP_NO_STR } },
      { "Cj", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ad", PROP_REAL, { 0, PROP_NO_STR } },
      { "As", PROP_REAL, { 0, PROP_NO_STR } },
      { "Pd", PROP_REAL, { 0, PROP_NO_STR } },
      { "Ps", PROP_REAL, { 0, PROP_NO_STR } },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR } },
      { "Af", PROP_REAL, { 1, PROP_NO_STR } },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR } },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR } },
      { "EgTA", PROP_REAL, { 7.02e-4, PROP_NO_STR } },
      { "EgTB", PROP_REAL, { 1108.0, PROP_NO_STR } },
      PROP_NO_PROP },
      {-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* equation defined device */
  { "EDD", PROP_NODES, PROP_COMPONENT,
    { { "ports", PROP_INT, { 2, PROP_NO_STR } },
      { "I1", PROP_REAL, { 0, PROP_NO_STR } }, 
      { "Q1", PROP_REAL, { 0, PROP_NO_STR } }, 
      PROP_NO_PROP },
      {-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* HICUM Level 2 verilog device */
  { "HIC2", 5, PROP_COMPONENT,
    { { "c10", PROP_REAL, { 2.0E-30, PROP_NO_STR } },
      { "qp0", PROP_REAL, { 2.0E-14, PROP_NO_STR } },
      { "ich", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "hf0", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "hfe", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "hfc", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "hjei", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ahjei", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rhjei", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "hjci", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ibeis", PROP_REAL, { 1.0E-18, PROP_NO_STR } },
      { "mbei", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ireis", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mrei", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "ibeps", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mbep", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ireps", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mrep", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "mcf", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "tbhrec", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "ibcis", PROP_REAL, { 1.0E-16, PROP_NO_STR } },
      { "mbci", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ibcxs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mbcx", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ibets", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "abet", PROP_REAL, { 40, PROP_NO_STR } },
      { "tunode", PROP_STR, { PROP_NO_VAL, "PE" } },
      { "favl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "qavl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alfav", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alqav", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rbi0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rbx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "fgeo", PROP_REAL, { 0.6557, PROP_NO_STR } },
      { "fdqr0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "fcrbi", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "fqi", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "re", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rcx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "itss", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "msf", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "iscs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "msc", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "tsf", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rsu", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "csu", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "cjei0", PROP_REAL, { 1.0E-20, PROP_NO_STR } },
      { "vdei", PROP_REAL, { 0.9, PROP_NO_STR } },
      { "zei", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "ajei", PROP_REAL, { 2.5, PROP_NO_STR } },
      { "cjep0", PROP_REAL, { 1.0E-20, PROP_NO_STR } },
      { "vdep", PROP_REAL, { 0.9, PROP_NO_STR } },
      { "zep", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "ajep", PROP_REAL, { 2.5, PROP_NO_STR } },
      { "cjci0", PROP_REAL, { 1.0E-20, PROP_NO_STR } },
      { "vdci", PROP_REAL, { 0.7, PROP_NO_STR } },
      { "zci", PROP_REAL, { 0.4, PROP_NO_STR } },
      { "vptci", PROP_REAL, { 100, PROP_NO_STR } },
      { "cjcx0", PROP_REAL, { 1.0E-20, PROP_NO_STR } },
      { "vdcx", PROP_REAL, { 0.7, PROP_NO_STR } },
      { "zcx", PROP_REAL, { 0.4, PROP_NO_STR } },
      { "vptcx", PROP_REAL, { 100, PROP_NO_STR } },
      { "fbcpar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "fbepar", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "cjs0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "vds", PROP_REAL, { 0.6, PROP_NO_STR } },
      { "zs", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "vpts", PROP_REAL, { 100, PROP_NO_STR } },
      { "t0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "dt0h", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tbvl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tef0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "gtfe", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "thcs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "ahc", PROP_REAL, { 0.1, PROP_NO_STR } },
      { "fthc", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rci0", PROP_REAL, { 150, PROP_NO_STR } },
      { "vlim", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "vces", PROP_REAL, { 0.1, PROP_NO_STR } },
      { "vpt", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tr", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "vcbar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "icbar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "acbar", PROP_REAL, { 0.01, PROP_NO_STR } },
      { "delck", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "cbepar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "cbcpar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alqf", PROP_REAL, { 0.167, PROP_NO_STR } },
      { "alit", PROP_REAL, { 0.333, PROP_NO_STR } },
      { "flnqs", PROP_STR, { PROP_NO_VAL, "no" } },
      { "kf", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "af", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "cfbe", PROP_STR, { PROP_NO_VAL, "IB" } },
      { "flcono", PROP_STR, { PROP_NO_VAL, "no" } },
      { "kfre", PROP_INT, { 0.0, PROP_NO_STR } },
      { "afre", PROP_INT, { 2.0, PROP_NO_STR } },
      { "latb", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "latl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "vgb", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "alt0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "kt0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetaci", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alvs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alces", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarbi", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarbx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarcx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetare", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetacx", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "vge", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "vgc", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "vgs", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "f1vg", PROP_REAL, { (-1.02377e-4), PROP_NO_STR } },
      { "f2vg", PROP_REAL, { 4.3215e-4, PROP_NO_STR } },
      { "zetact", PROP_REAL, { 3.0, PROP_NO_STR } },
      { "zetabet", PROP_REAL, { 3.5, PROP_NO_STR } },
      { "alb", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "dvgbe", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetahjei", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "zetavgbe", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "flsh", PROP_STR, { PROP_NO_VAL, "off" } },
      { "rth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alrth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "cth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "flcomp", PROP_STR, { PROP_NO_VAL, "2.1" } },
      { "tnom", PROP_REAL, { 27.0, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 27.0, PROP_NO_STR } },
      { "Type", PROP_STR, { PROP_NO_VAL, "npn" } },
      PROP_NO_PROP },
      {-30,0,0,30,0,-30,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,-30,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* HICUM Level 0 verilog device */
  { "HIC0", 5, PROP_COMPONENT,
    {
      { "is", PROP_REAL, { 1.0e-16, PROP_NO_STR } },
      { "it_mod", PROP_STR, { PROP_NO_VAL, "no" } },
      { "mcf", PROP_REAL, { 1.00, PROP_NO_STR } },
      { "mcr", PROP_REAL, { 1.00, PROP_NO_STR } },
      { "vef", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "ver", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "aver", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "iqf", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "fiqf", PROP_STR, { PROP_NO_VAL, "no" } },
      { "iqr", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "iqfh", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "tfh", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "ahq", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "ibes", PROP_REAL, { 1e-18, PROP_NO_STR } },
      { "mbe", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "ires", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mre", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "ibcs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "mbc", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "cje0", PROP_REAL, { 1.0e-20, PROP_NO_STR } },
      { "vde", PROP_REAL, { 0.9, PROP_NO_STR } },
      { "ze", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "aje", PROP_REAL, { 2.5, PROP_NO_STR } },
      { "vdedc", PROP_REAL, { 0.9, PROP_NO_STR } },
      { "zedc", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "ajedc", PROP_REAL, { 2.5, PROP_NO_STR } },
      { "t0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "dt0h", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tbvl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tef0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "gte", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "thcs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "ahc", PROP_REAL, { 0.1, PROP_NO_STR } },
      { "tr", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rci0", PROP_REAL, { 150, PROP_NO_STR } },
      { "vlim", PROP_REAL, { 0.5, PROP_NO_STR } },
      { "vpt", PROP_REAL, { 100, PROP_NO_STR } },
      { "vces", PROP_REAL, { 0.1, PROP_NO_STR } },
      { "cjci0", PROP_REAL, { 1.0e-20, PROP_NO_STR } },
      { "vdci", PROP_REAL, { 0.7, PROP_NO_STR } },
      { "zci", PROP_REAL, { 0.333, PROP_NO_STR } },
      { "vptci", PROP_REAL, { 100, PROP_NO_STR } },
      { "cjcx0", PROP_REAL, { 1.0e-20, PROP_NO_STR } },
      { "vdcx", PROP_REAL, { 0.7, PROP_NO_STR } },
      { "zcx", PROP_REAL, { 0.333, PROP_NO_STR } },
      { "vptcx", PROP_REAL, { 100, PROP_NO_STR } },
      { "fbc", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "rbi0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "vr0e", PROP_REAL, { 2.5, PROP_NO_STR } },
      { "vr0c", PROP_REAL, { 1.0e6, PROP_NO_STR } },
      { "fgeo", PROP_REAL, { 0.656, PROP_NO_STR } },
      { "rbx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "rcx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "re", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "itss", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "msf", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "iscs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "msc", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "cjs0", PROP_REAL, { 1.0e-20, PROP_NO_STR } },
      { "vds", PROP_REAL, { 0.3, PROP_NO_STR } },
      { "zs", PROP_REAL, { 0.3, PROP_NO_STR } },
      { "vpts", PROP_REAL, { 100, PROP_NO_STR } },
      { "cbcpar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "cbepar", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "eavl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "kavl", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "kf", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "af", PROP_REAL, { 2.0, PROP_NO_STR } },
      { "alqf", PROP_REAL, { 0.167, PROP_NO_STR } },
      { "alit", PROP_REAL, { 0.333, PROP_NO_STR } },
      { "flnqs", PROP_STR, { PROP_NO_VAL, "no" } },
      { "vgb", PROP_REAL, { 1.2, PROP_NO_STR } },
      { "vge", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "vgc", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "vgs", PROP_REAL, { 1.17, PROP_NO_STR } },
      { "f1vg", PROP_REAL, { -1.02377e-4, PROP_NO_STR } },
      { "alt0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "kt0", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetact", PROP_REAL, { 3.0, PROP_NO_STR } },
      { "zetabet", PROP_REAL, { 3.5, PROP_NO_STR } },
      { "zetaci", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alvs", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alces", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarbi", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarbx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarcx", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetare", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetaiqf", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "alkav", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "aleav", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "zetarth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "tef_temp", PROP_STR, { PROP_NO_VAL, "on" } },
      { "zetaver", PROP_REAL, { -1.0, PROP_NO_STR } },
      { "zetavgbe", PROP_REAL, { 1.0, PROP_NO_STR } },
      { "dvgbe", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "aliqfh", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "kiqfh", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "flsh", PROP_STR, { PROP_NO_VAL, "no" } },
      { "rth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "cth", PROP_REAL, { 0.0, PROP_NO_STR } },
      { "Tnom", PROP_REAL, { 27.0, PROP_NO_STR } },
      { "Temp", PROP_REAL, { 27.0, PROP_NO_STR } },
      { "type", PROP_STR, { PROP_NO_VAL, "npn" } },
      PROP_NO_PROP },
      {-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,-30,30,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* parameter sweep */
  { "SW", 0, PROP_ACTION,
    { { "Sim", PROP_STR, { PROP_NO_VAL, "DC1" } },
      { "Param", PROP_STR, { PROP_NO_VAL, "R1" } },
      { "Type", PROP_STR, { PROP_NO_VAL, "lin" } },
      { "Start", PROP_REAL, { 5, PROP_NO_STR } },
      { "Stop", PROP_REAL, { 50, PROP_NO_STR } },
      { "Points", PROP_INT, { 5, PROP_NO_STR } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* ac analysis */
  { "AC", 0, PROP_ACTION,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" } },
      { "Start", PROP_REAL, { 1e9, PROP_NO_STR } },
      { "Stop", PROP_REAL, { 10e9, PROP_NO_STR } },
      { "Points", PROP_INT, { 10, PROP_NO_STR } },
      { "Noise", PROP_STR, { PROP_NO_VAL, "no" } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* transient analysis */
  { "TR", 0, PROP_ACTION,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" } },
      { "Start", PROP_REAL, { 0, PROP_NO_STR } },
      { "Stop", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "Points", PROP_INT, { 101, PROP_NO_STR } },
      { "method", PROP_STR, { PROP_NO_VAL, "Trapezoidal" } },
      { "MinStep", PROP_REAL, { 1e-16, PROP_NO_STR } },
      { "MaxIter", PROP_INT, { 300, PROP_NO_STR } },
      { "reltol", PROP_REAL, { 1e-3, PROP_NO_STR } },
      { "abstol", PROP_REAL, { 1e-6, PROP_NO_STR } },
      { "initialDC", PROP_STR, { PROP_NO_VAL, "yes" } },
      PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* subcircuit instance */
  { "Sub", PROP_NODES, PROP_COMPONENT,
    { { "Type", PROP_STR, { PROP_NO_VAL, "DEF1" } }, PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },
  /* nodeset definition */
  { "NodeSet", 1, PROP_COMPONENT,
    { { "U", PROP_REAL, { 0, PROP_NO_STR } }, PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  },

  /* end of list */
  { NULL, 0, 0, { PROP_NO_PROP },
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }
};

#endif /* __QUCSDEFS_H__ */
