/*
 * precision.h - global precision header file
 *
 * Copyright (C) 2005, 2006 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: precision.h,v 1.1 2008/01/15 19:14:01 ela Exp $
 *
 */

#ifndef __PRECISION_H__
#define __PRECISION_H__

#ifndef __FLT_EPSILON__
#define __FLT_EPSILON__  1.1920928955078125e-07
#endif
#ifndef __FLT_MIN__
#define __FLT_MIN__      1.1754943508222875e-38
#endif
#ifndef __FLT_MAX__
#define __FLT_MAX__      3.4028234663852886e+38
#endif

#ifndef __DBL_EPSILON__
#define __DBL_EPSILON__  2.2204460492503131e-16
#endif
#ifndef __DBL_MIN__
#define __DBL_MIN__      2.2250738585072014e-308
#endif
#ifndef __DBL_MAX__
#define __DBL_MAX__	 1.7976931348623157e+308
#endif

  /* double precision */
#define NR_TYPE double
#define NR_EPSI __DBL_EPSILON__
#define NR_MIN  __DBL_MIN__
#define NR_MAX  __DBL_MAX__
#define NR_TINY 1e-12
#define NR_DECS "11" /* 15 digits */

#endif /* __PRECISION_H__ */
