
/* A Bison parser, made by GNU Bison 2.7.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         spice_parse
#define yylex           spice_lex
#define yyerror         spice_error
#define yylval          spice_lval
#define yychar          spice_char
#define yydebug         spice_debug
#define yynerrs         spice_nerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 3 "parse_spice.y"

/*
 * parse_spice.y - parser for a Spice netlist
 *
 * Copyright (C) 2004-2009 Stefan Jahn <stefan@lkcc.org>
 * Copyright (C) 2018 Michael Margraf
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define YYERROR_VERBOSE 42
#define YYDEBUG 1
#define YYMAXDEPTH 1000000

#include "check_spice.h"

// Converts the given string into upper case.
static char * spice_toupper (char * str) {
  for (unsigned int i = 0; i < strlen (str); i++) {
    if (str[i] >= 'a' && str[i] <= 'z') str[i] = toupper (str[i]);
  }
  return str;
}

// Creates a device instance.
static struct definition_t * spice_create_device (char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_COMPONENT;
  def->instance = spice_toupper (instance);
  def->type = (char *) calloc (2, 1);
  def->type[0] = def->instance[0];
  def->line = spice_lineno - 1;
  def->description = spice_comment;
  spice_comment = NULL;
  return def;
}

// Creates an action instance.
static struct definition_t * spice_create_action (char * type,
						  char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_ACTION;
  def->instance = spice_toupper (instance);
  def->type = spice_toupper (type);
  def->line = spice_lineno - 1;
  def->description = spice_comment;
  spice_comment = NULL;
  return def;
}

// Create a string value.
static struct value_t * spice_create_str_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = spice_toupper (value);
  val->hint |= hint;
  return val;
}

// Create a real value.
static struct value_t * spice_create_val_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = value;
  val->value = strtod (value, NULL);
  val->hint |= hint;
  return val;
}

// Create a key/value pair.
static struct value_t * spice_create_par_value (char * key, char * value) {
  struct value_t * val = spice_create_str_value (key, HINT_PAIR);
  val->unit = value;
  return val;
}

// Append a string value to the definition.
static void spice_append_str_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a string value to the given values.
static struct value_t * spice_append_str_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  return netlist_append_values (values, val);
}

// Append a real value to the definition.
static void spice_append_val_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a real value to the given values.
static struct value_t * spice_append_val_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  return netlist_append_values (values, val);
}



/* Line 189 of yacc.c  */
#line 204 "parse_spice.cpp"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE b4_token_table
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     InvalidCharacter = 258,
     End = 259,
     Eol = 260,
     Identifier = 261,
     Digits = 262,
     Floats = 263,
     Nodes = 264,
     Options = 265,
     Function = 266,
     SUBCKT_Action = 267,
     ENDS_Action = 268,
     AC_Action = 269,
     OP_Action = 270,
     I_Source = 271,
     SAVE_Action = 272,
     RLC_Device = 273,
     L_Device = 274,
     K_Device = 275,
     IV_Source = 276,
     GE_Source = 277,
     FH_Source = 278,
     V_Source = 279,
     Diode_Device = 280,
     Bipolar_Device = 281,
     JFET_Device = 282,
     MOSFET_Device = 283,
     MESFET_Device = 284,
     MODEL_Action = 285,
     MODEL_Spec = 286,
     TRAN_Action = 287,
     PLOT_Action = 288,
     VoltFunc = 289,
     CurrFunc = 290,
     DC_Action = 291,
     PRINT_Action = 292,
     OPTIONS_Action = 293,
     WIDTH_Action = 294,
     NOISE_Action = 295,
     PZ_Action = 296,
     CurVol = 297,
     PoleZero = 298,
     ALL_Special = 299,
     X_Device = 300,
     O_Device = 301,
     ModelProps = 302,
     OFF_Special = 303,
     IC_Special = 304,
     SIM_Type = 305,
     TEMP_Special = 306,
     MOS_Special = 307,
     B_Source = 308,
     DISTO_Action = 309,
     INCLUDE_Action = 310,
     File = 311,
     BranchFunc = 312,
     NODESET_Action = 313,
     T_Device = 314,
     U_Device = 315,
     S_Device = 316,
     W_Device = 317,
     ON_Special = 318,
     TF_Action = 319,
     SENS_Action = 320,
     FOUR_Action = 321,
     OpFunc = 322,
     Behave = 323,
     TC_Special = 324,
     TEMP_Action = 325
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 140 "parse_spice.y"

  char * ident;
  double d;
  struct definition_t * definition;
  struct definition_t * subcircuit;
  struct value_t * value;



/* Line 214 of yacc.c  */
#line 320 "parse_spice.cpp"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 332 "parse_spice.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  112
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   613

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  71
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  42
/* YYNRULES -- Number of rules.  */
#define YYNRULES  147
/* YYNRULES -- Number of states.  */
#define YYNSTATES  353

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   325

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     6,     8,     9,    12,    14,    16,    18,
      20,    27,    35,    42,    49,    56,    63,    71,    77,    83,
      90,    98,   104,   112,   121,   127,   134,   140,   146,   153,
     160,   168,   176,   183,   187,   192,   196,   199,   203,   208,
     213,   217,   222,   226,   230,   234,   240,   249,   253,   262,
     270,   278,   286,   294,   303,   306,   309,   312,   315,   318,
     321,   325,   329,   333,   336,   340,   343,   347,   352,   358,
     361,   363,   366,   370,   372,   374,   377,   379,   381,   382,
     385,   389,   392,   396,   397,   399,   401,   402,   405,   408,
     409,   412,   416,   417,   420,   424,   425,   430,   431,   435,
     438,   441,   444,   445,   449,   452,   455,   458,   462,   463,
     467,   471,   474,   477,   480,   482,   484,   489,   491,   493,
     495,   497,   499,   501,   503,   504,   508,   509,   512,   513,
     516,   519,   520,   523,   524,   527,   530,   531,   534,   538,
     543,   544,   547,   549,   551,   554,   556,   558
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      72,     0,    -1,    73,     4,    -1,    73,    -1,    -1,    74,
      73,    -1,   107,    -1,    75,    -1,    13,    -1,     5,    -1,
      18,    98,    98,    97,   100,     5,    -1,    18,    98,    98,
      97,    95,   100,     5,    -1,    18,    98,    98,    95,    97,
       5,    -1,    18,    98,    98,    95,   100,     5,    -1,    18,
      98,    98,    97,    76,     5,    -1,    18,    98,    98,    97,
      77,     5,    -1,    18,    98,    98,    97,    68,   102,     5,
      -1,    20,    19,    19,    97,     5,    -1,    21,    98,    98,
     106,     5,    -1,    21,    98,    98,    97,   106,     5,    -1,
      22,    98,    98,    68,     7,   102,     5,    -1,    22,    98,
      98,    68,     5,    -1,    22,    98,    98,    98,    98,    97,
       5,    -1,    23,    99,    99,    68,     7,   104,   102,     5,
      -1,    23,    99,    99,    68,     5,    -1,    23,    99,    99,
      24,    97,     5,    -1,    30,    95,    31,    90,     5,    -1,
      25,    98,    98,    95,    92,    -1,    27,    98,    98,    98,
      95,    93,    -1,    26,    98,    98,    98,    95,    93,    -1,
      26,    98,    98,    98,    98,    95,    93,    -1,    28,    98,
      98,    98,    98,    95,    94,    -1,    29,    98,    98,    98,
      95,    93,    -1,    32,   101,     5,    -1,    33,    50,    86,
       5,    -1,    14,   105,     5,    -1,    36,     5,    -1,    36,
      96,     5,    -1,    36,    96,    96,     5,    -1,    37,    50,
      88,     5,    -1,    37,    88,     5,    -1,    37,    50,    44,
       5,    -1,    38,    89,     5,    -1,    70,   101,     5,    -1,
      39,   100,     5,    -1,    40,    83,    84,   105,     5,    -1,
      41,    98,    98,    98,    98,    42,    43,     5,    -1,    45,
     103,     5,    -1,    61,    98,    98,    98,    98,    95,    87,
       5,    -1,    62,    98,    98,    24,    95,    87,     5,    -1,
      46,    98,    98,    98,    98,    95,     5,    -1,    60,    98,
      98,    98,    95,   100,     5,    -1,    59,    98,    98,    98,
      98,   100,     5,    -1,    59,    98,    98,    98,    98,   100,
      81,     5,    -1,    15,     5,    -1,    17,     5,    -1,    65,
       5,    -1,    64,     5,    -1,    66,     5,    -1,    53,     5,
      -1,    54,   105,     5,    -1,    55,    56,     5,    -1,    58,
      91,     5,    -1,    69,    97,    -1,    69,    97,    97,    -1,
      49,    97,    -1,    49,    97,    97,    -1,    49,    97,    97,
      97,    -1,    49,    97,    97,    97,    97,    -1,    97,    97,
      -1,    98,    -1,    34,    98,    -1,    34,    98,    98,    -1,
      16,    -1,    24,    -1,    35,    24,    -1,    57,    -1,    67,
      -1,    -1,    83,    86,    -1,    83,    82,    86,    -1,    85,
      86,    -1,    85,    82,    86,    -1,    -1,    63,    -1,    48,
      -1,    -1,    83,    86,    -1,    85,    86,    -1,    -1,    10,
      89,    -1,     6,    97,    89,    -1,    -1,    47,    90,    -1,
       6,    97,    90,    -1,    -1,    34,    98,    97,    91,    -1,
      -1,    51,    97,    92,    -1,    97,    92,    -1,    48,    92,
      -1,    78,    92,    -1,    -1,    51,    97,    93,    -1,    97,
      93,    -1,    48,    93,    -1,    79,    93,    -1,    52,    97,
      93,    -1,    -1,    51,    97,    94,    -1,    52,    97,    94,
      -1,    97,    94,    -1,    48,    94,    -1,    80,    94,    -1,
       6,    -1,    31,    -1,    84,    97,    97,    97,    -1,     7,
      -1,     8,    -1,     7,    -1,     9,    -1,     6,    -1,    98,
      -1,    24,    -1,    -1,     6,    97,   100,    -1,    -1,    97,
     101,    -1,    -1,    98,   102,    -1,     8,   102,    -1,    -1,
      98,   103,    -1,    -1,    24,   104,    -1,    11,   101,    -1,
      -1,   105,   106,    -1,   108,   109,   111,    -1,    12,   110,
     103,     5,    -1,    -1,   112,   109,    -1,     6,    -1,    13,
      -1,    13,   110,    -1,    75,    -1,   107,    -1,     5,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   174,   174,   175,   178,   179,   183,   188,   195,   196,
     200,   208,   217,   225,   233,   241,   249,   258,   265,   272,
     280,   295,   300,   309,   325,   330,   338,   345,   353,   362,
     371,   381,   391,   400,   405,   411,   416,   420,   425,   430,
     436,   441,   447,   452,   457,   462,   469,   479,   485,   495,
     504,   513,   522,   531,   541,   545,   549,   553,   557,   561,
     565,   570,   578,   586,   593,   601,   609,   617,   627,   638,
     646,   652,   658,   668,   668,   671,   677,   683,   691,   692,
     695,   699,   702,   708,   709,   712,   717,   718,   721,   726,
     727,   731,   737,   738,   742,   748,   749,   758,   759,   763,
     767,   771,   776,   777,   781,   785,   789,   792,   798,   799,
     803,   807,   811,   815,   820,   820,   823,   833,   833,   835,
     835,   835,   837,   837,   839,   840,   846,   847,   853,   854,
     858,   864,   865,   871,   872,   879,   886,   887,   893,   901,
     907,   908,   919,   922,   923,   927,   933,   934
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "InvalidCharacter", "End", "Eol",
  "Identifier", "Digits", "Floats", "Nodes", "Options", "Function",
  "SUBCKT_Action", "ENDS_Action", "AC_Action", "OP_Action", "I_Source",
  "SAVE_Action", "RLC_Device", "L_Device", "K_Device", "IV_Source",
  "GE_Source", "FH_Source", "V_Source", "Diode_Device", "Bipolar_Device",
  "JFET_Device", "MOSFET_Device", "MESFET_Device", "MODEL_Action",
  "MODEL_Spec", "TRAN_Action", "PLOT_Action", "VoltFunc", "CurrFunc",
  "DC_Action", "PRINT_Action", "OPTIONS_Action", "WIDTH_Action",
  "NOISE_Action", "PZ_Action", "CurVol", "PoleZero", "ALL_Special",
  "X_Device", "O_Device", "ModelProps", "OFF_Special", "IC_Special",
  "SIM_Type", "TEMP_Special", "MOS_Special", "B_Source", "DISTO_Action",
  "INCLUDE_Action", "File", "BranchFunc", "NODESET_Action", "T_Device",
  "U_Device", "S_Device", "W_Device", "ON_Special", "TF_Action",
  "SENS_Action", "FOUR_Action", "OpFunc", "Behave", "TC_Special",
  "TEMP_Action", "$accept", "Input", "InputList", "InputLine",
  "DefinitionLine", "TC_Value_1", "TC_Value_2", "IC_Condition_1",
  "IC_Condition_2", "IC_Condition_3", "IC_Condition_4", "Output_Range",
  "VOLTAGE_Output", "IV_Reference", "CURRENT_Output", "PLOT_List",
  "SWITCH_State", "PRINT_List", "OPTIONS_List", "MODEL_List",
  "NODESET_List", "DEVICE_List_1", "DEVICE_List_2", "DEVICE_List_3",
  "MODEL_Ident", "DC_List", "Value", "Node", "FH_Node", "PairList",
  "ValueList", "NodeValueList", "NodeList", "VSourceList", "Expr",
  "ExprList", "Subcircuit", "BeginSub", "SubBody", "SubCkt_Ident",
  "EndSub", "SubBodyLine", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    71,    72,    72,    73,    73,    74,    74,    74,    74,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    83,    83,    84,    84,    85,    85,    85,    86,    86,
      86,    86,    86,    87,    87,    87,    88,    88,    88,    89,
      89,    89,    90,    90,    90,    91,    91,    92,    92,    92,
      92,    92,    93,    93,    93,    93,    93,    93,    94,    94,
      94,    94,    94,    94,    95,    95,    96,    97,    97,    98,
      98,    98,    99,    99,   100,   100,   101,   101,   102,   102,
     102,   103,   103,   104,   104,   105,   106,   106,   107,   108,
     109,   109,   110,   111,   111,   112,   112,   112
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     1,     0,     2,     1,     1,     1,     1,
       6,     7,     6,     6,     6,     6,     7,     5,     5,     6,
       7,     5,     7,     8,     5,     6,     5,     5,     6,     6,
       7,     7,     6,     3,     4,     3,     2,     3,     4,     4,
       3,     4,     3,     3,     3,     5,     8,     3,     8,     7,
       7,     7,     7,     8,     2,     2,     2,     2,     2,     2,
       3,     3,     3,     2,     3,     2,     3,     4,     5,     2,
       1,     2,     3,     1,     1,     2,     1,     1,     0,     2,
       3,     2,     3,     0,     1,     1,     0,     2,     2,     0,
       2,     3,     0,     2,     3,     0,     4,     0,     3,     2,
       2,     2,     0,     3,     2,     2,     2,     3,     0,     3,
       3,     2,     2,     2,     1,     1,     4,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     0,     2,     0,     2,
       2,     0,     2,     0,     2,     2,     0,     2,     3,     4,
       0,     2,     1,     1,     2,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       4,     9,     0,     8,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   126,     0,
       0,    86,    89,   124,     0,     0,   131,     0,     0,     0,
       0,    95,     0,     0,     0,     0,     0,     0,     0,   126,
       0,     3,     4,     7,     6,   140,   142,   131,   126,     0,
      54,    55,   121,   119,   120,     0,     0,     0,     0,   123,
     122,     0,     0,     0,     0,     0,     0,   114,   115,     0,
     117,   118,   126,     0,    78,    36,    73,    74,     0,     0,
       0,     0,    86,    76,    77,    78,    78,     0,    70,     0,
      89,     0,     0,     0,     0,     0,   131,     0,     0,    59,
       0,     0,     0,     0,     0,     0,     0,     0,    57,    56,
      58,     0,     1,     2,     5,   147,   145,   146,     0,   140,
       0,   135,    35,     0,     0,   136,     0,     0,     0,     0,
       0,     0,     0,    92,   127,    33,    78,    78,     0,     0,
      37,     0,    71,    75,     0,     0,    87,    88,    40,    89,
      90,    42,   124,    44,     0,     0,   132,    47,     0,    60,
      61,     0,    62,     0,     0,     0,     0,    43,   143,   138,
     141,   139,   124,   124,     0,   136,   136,     0,     0,     0,
       0,     0,    97,     0,     0,     0,     0,     0,    92,     0,
     119,    78,    79,     0,    78,    81,    34,     0,    38,    72,
      41,    39,    91,   125,     0,     0,     0,    95,     0,     0,
       0,     0,   144,     0,     0,   114,   128,     0,     0,     0,
     124,     0,    17,     0,   137,    18,    21,   128,     0,     0,
      24,   133,    97,     0,     0,    97,    27,    97,   114,   102,
       0,   102,     0,   102,    92,    93,    26,    80,    69,    82,
     116,    45,     0,     0,    96,   124,   124,     0,    83,    12,
      13,   128,   128,     0,    63,    14,    15,     0,    10,    19,
       0,     0,    25,   133,   128,   100,    65,    97,   101,    99,
     102,     0,     0,     0,   102,    29,   102,   102,    28,   108,
      32,    94,     0,     0,     0,     0,    83,    85,    84,     0,
     130,   129,    16,    64,    11,    20,    22,   134,     0,    98,
     105,     0,   102,   102,   106,   104,    30,   108,     0,     0,
       0,   108,    31,   108,     0,    50,    52,     0,     0,    51,
       0,    49,    23,    66,   103,   107,   112,     0,   108,   108,
     113,   111,    46,     0,    53,    48,     0,   109,   110,     0,
      67,     0,    68
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    40,    41,    42,    43,   218,   219,   235,   284,   321,
     328,   191,   136,    78,   137,   138,   299,    87,    91,   189,
     103,   236,   285,   322,    69,    79,   286,    88,    61,    93,
      73,   263,    97,   274,   176,   177,    44,    45,   118,    47,
     169,   119
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -220
static const yytype_int16 yypact[] =
{
     215,  -220,    21,  -220,    25,    34,    38,   277,    64,   277,
     277,   174,   277,   277,   277,   277,   277,     9,   109,    76,
     107,    35,    23,   126,   129,   277,   277,   277,   136,    25,
      88,   114,   277,   277,   277,   277,   161,   172,   177,   109,
     196,   181,   215,  -220,  -220,   543,  -220,   277,   109,   213,
    -220,  -220,  -220,  -220,  -220,   277,   204,   277,   277,  -220,
    -220,   174,   277,   277,   277,   277,   277,  -220,  -220,   195,
    -220,  -220,   109,   226,   133,  -220,  -220,  -220,   109,   160,
     277,   210,    90,  -220,  -220,   133,   133,   234,  -220,   109,
      23,   244,   109,   245,    79,   277,   277,   252,   277,  -220,
     253,   257,   277,   261,   277,   277,   277,   277,  -220,  -220,
    -220,   262,  -220,  -220,  -220,  -220,  -220,  -220,   259,   543,
     273,  -220,  -220,    80,   109,    93,     7,   -17,     9,   277,
     277,   277,   277,    51,  -220,  -220,   121,   121,   282,   109,
    -220,   283,   277,  -220,   284,   285,  -220,  -220,  -220,    23,
    -220,  -220,   126,  -220,    25,   277,  -220,  -220,   277,  -220,
    -220,   109,  -220,   277,   277,   277,   258,  -220,    21,  -220,
    -220,  -220,   205,     4,   286,    25,    25,   287,   167,   277,
     109,   201,   138,   164,     9,   277,     9,   109,    51,   289,
     151,   133,  -220,   109,   133,  -220,  -220,   109,  -220,  -220,
    -220,  -220,  -220,  -220,   290,   277,   277,   114,   277,     9,
     277,     9,  -220,   291,   292,   109,   185,   109,   293,   299,
     126,   301,  -220,   302,  -220,  -220,  -220,   185,   109,   303,
    -220,   288,   138,   109,   109,   138,  -220,   138,    31,   101,
       9,   101,     9,   101,    51,  -220,  -220,  -220,  -220,  -220,
    -220,  -220,   268,     9,  -220,   126,   126,     9,   -14,  -220,
    -220,   185,   185,   306,   109,  -220,  -220,   308,  -220,  -220,
     309,   310,  -220,   288,   185,  -220,  -220,   138,  -220,  -220,
     101,   109,   109,   109,   101,  -220,   101,   101,  -220,   153,
    -220,  -220,   274,   311,    33,   313,   -14,  -220,  -220,   317,
    -220,  -220,  -220,  -220,  -220,  -220,  -220,  -220,   318,  -220,
    -220,   109,   101,   101,  -220,  -220,  -220,   153,   109,   109,
     109,   153,  -220,   153,   319,  -220,  -220,   109,   321,  -220,
     322,  -220,  -220,  -220,  -220,  -220,  -220,   109,   153,   153,
    -220,  -220,  -220,   109,  -220,  -220,   109,  -220,  -220,   109,
    -220,   109,  -220
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -220,  -220,   300,  -220,   -43,  -220,  -220,  -220,  -220,  -220,
    -220,   192,    -4,   236,     2,   -81,    47,   263,   -72,  -163,
     137,  -187,  -219,  -114,  -120,   267,   -18,   325,   294,  -141,
     -20,  -215,   -38,    74,    -3,    46,   -39,  -220,   229,   186,
    -220,  -220
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -122
static const yytype_int16 yytable[] =
{
      72,    49,   116,   172,   146,   147,   117,   180,   182,   120,
     215,   203,   270,    52,    53,    67,    54,    85,   150,   111,
      94,    72,   288,    86,   290,   245,   100,    46,   121,    89,
      72,   214,   221,    90,   297,    68,    48,  -121,   326,    50,
      68,    52,    53,    51,    54,   275,   300,   301,   278,   298,
     279,   181,   134,   220,    72,   192,   195,   187,   156,   308,
     139,   310,  -121,   239,   241,   314,   243,   315,   316,    80,
      81,   149,   216,   217,   152,   178,   116,   202,    85,   267,
     117,   291,   327,    56,    86,    82,    67,    70,    71,   256,
     309,   258,    83,   334,   335,    76,    52,    53,   188,    54,
      70,    71,    84,    77,    48,   173,   174,   175,    70,    71,
     247,    68,    75,   249,   294,   295,    70,    71,   193,   193,
     287,   197,   289,    76,    80,    81,    74,    52,   190,    71,
      54,    77,    92,   293,   144,    52,    53,   296,    54,    52,
      53,    99,    54,   207,   101,    70,    71,    83,   102,   280,
     281,   204,   282,   283,   213,    80,    81,    84,  -117,  -117,
      70,    71,   229,    80,   237,   140,   108,    80,    81,   244,
     238,    53,   226,    54,   227,   248,    76,   109,    83,   250,
      52,    53,   110,    54,    77,   113,   232,   233,    84,   234,
      83,    52,    53,   261,    54,    68,   112,   152,    59,   264,
      84,   317,   318,   336,   319,   320,   230,   340,   231,   341,
     271,    92,    70,    71,   237,   276,   277,   237,   122,   237,
       1,   223,   224,   124,   347,   348,   133,     2,     3,     4,
       5,   135,     6,     7,   143,     8,     9,    10,    11,   148,
      12,    13,    14,    15,    16,    17,   303,    18,    19,   151,
     153,    20,    21,    22,    23,    24,    25,   157,   159,   237,
      26,    27,   160,   311,   312,   313,   162,   167,    28,    29,
      30,   323,   168,    31,    32,    33,    34,    35,   171,    36,
      37,    38,   211,    52,    53,    39,    54,   196,   198,   200,
     201,   222,   225,   333,   246,   251,   259,   260,   265,   323,
     337,   338,   339,   323,   266,   323,   268,   269,   272,   343,
     292,   302,   273,   304,   305,   306,   325,   324,   329,   346,
     323,   323,   331,   332,   342,   349,   344,   345,   350,   194,
     154,   351,    55,   352,    57,    58,    60,    62,    63,    64,
      65,    66,   114,   330,   254,   145,   141,   307,   170,     0,
      95,    96,    98,     0,   212,   127,     0,   104,   105,   106,
     107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    96,     0,     0,     0,     0,     0,     0,     0,
     123,     0,   125,   126,     0,     0,    60,   128,   129,   130,
     131,   132,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,    96,     0,   158,     0,     0,     0,   161,     0,   163,
     164,   165,   166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,     0,     0,   183,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   206,     0,     0,     0,     0,   208,   209,
     210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,     0,     0,   240,     0,
     242,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     252,   253,     0,   255,     0,   257,     0,     0,     0,     0,
       0,   262,     0,     0,     0,     0,     0,     0,   115,     0,
       0,     0,   262,     0,     0,     2,     0,     4,     5,     0,
       6,     7,     0,     8,     9,    10,    11,     0,    12,    13,
      14,    15,    16,    17,     0,    18,    19,     0,     0,    20,
      21,    22,    23,    24,    25,     0,   262,   262,    26,    27,
       0,     0,     0,     0,     0,     0,    28,    29,    30,   262,
       0,    31,    32,    33,    34,    35,     0,    36,    37,    38,
       0,     0,     0,    39
};

static const yytype_int16 yycheck[] =
{
      18,     4,    45,   123,    85,    86,    45,    24,   128,    47,
       6,   152,   227,     6,     7,     6,     9,    21,    90,    39,
      24,    39,   241,    21,   243,   188,    29,     6,    48,     6,
      48,   172,   173,    10,    48,    31,    11,     6,     5,     5,
      31,     6,     7,     5,     9,   232,   261,   262,   235,    63,
     237,    68,    72,   173,    72,   136,   137,     6,    96,   274,
      78,   280,    31,   183,   184,   284,   186,   286,   287,    34,
      35,    89,    68,    69,    92,    68,   119,   149,    82,   220,
     119,   244,    49,    19,    82,    50,     6,     7,     8,   209,
     277,   211,    57,   312,   313,    16,     6,     7,    47,     9,
       7,     8,    67,    24,    11,   123,   124,   125,     7,     8,
     191,    31,     5,   194,   255,   256,     7,     8,   136,   137,
     240,   139,   242,    16,    34,    35,    50,     6,     7,     8,
       9,    24,     6,   253,    44,     6,     7,   257,     9,     6,
       7,     5,     9,   161,    56,     7,     8,    57,    34,    48,
      49,   154,    51,    52,   172,    34,    35,    67,     7,     8,
       7,     8,   180,    34,   182,     5,     5,    34,    35,   187,
       6,     7,     5,     9,     7,   193,    16,     5,    57,   197,
       6,     7,     5,     9,    24,     4,    48,    49,    67,    51,
      57,     6,     7,     8,     9,    31,     0,   215,    24,   217,
      67,    48,    49,   317,    51,    52,     5,   321,     7,   323,
     228,     6,     7,     8,   232,   233,   234,   235,     5,   237,
       5,   175,   176,    19,   338,   339,    31,    12,    13,    14,
      15,     5,    17,    18,    24,    20,    21,    22,    23,     5,
      25,    26,    27,    28,    29,    30,   264,    32,    33,     5,
       5,    36,    37,    38,    39,    40,    41,     5,     5,   277,
      45,    46,     5,   281,   282,   283,     5,     5,    53,    54,
      55,   289,    13,    58,    59,    60,    61,    62,     5,    64,
      65,    66,    24,     6,     7,    70,     9,     5,     5,     5,
       5,     5,     5,   311,     5,     5,     5,     5,     5,   317,
     318,   319,   320,   321,     5,   323,     5,     5,     5,   327,
      42,     5,    24,     5,     5,     5,     5,    43,     5,   337,
     338,   339,     5,     5,     5,   343,     5,     5,   346,   137,
      94,   349,     7,   351,     9,    10,    11,    12,    13,    14,
      15,    16,    42,   296,   207,    82,    79,   273,   119,    -1,
      25,    26,    27,    -1,   168,    61,    -1,    32,    33,    34,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      55,    -1,    57,    58,    -1,    -1,    61,    62,    63,    64,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,    -1,    -1,   102,    -1,   104,
     105,   106,   107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   126,    -1,    -1,   129,   130,   131,   132,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     155,    -1,    -1,   158,    -1,    -1,    -1,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   179,    -1,    -1,    -1,   183,    -1,
     185,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,   210,    -1,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,   227,    -1,    -1,    12,    -1,    14,    15,    -1,
      17,    18,    -1,    20,    21,    22,    23,    -1,    25,    26,
      27,    28,    29,    30,    -1,    32,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    -1,   261,   262,    45,    46,
      -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,   274,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      -1,    -1,    -1,    70
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     5,    12,    13,    14,    15,    17,    18,    20,    21,
      22,    23,    25,    26,    27,    28,    29,    30,    32,    33,
      36,    37,    38,    39,    40,    41,    45,    46,    53,    54,
      55,    58,    59,    60,    61,    62,    64,    65,    66,    70,
      72,    73,    74,    75,   107,   108,     6,   110,    11,   105,
       5,     5,     6,     7,     9,    98,    19,    98,    98,    24,
      98,    99,    98,    98,    98,    98,    98,     6,    31,    95,
       7,     8,    97,   101,    50,     5,    16,    24,    84,    96,
      34,    35,    50,    57,    67,    83,    85,    88,    98,     6,
      10,    89,     6,   100,    83,    98,    98,   103,    98,     5,
     105,    56,    34,    91,    98,    98,    98,    98,     5,     5,
       5,   101,     0,     4,    73,     5,    75,   107,   109,   112,
     103,   101,     5,    98,    19,    98,    98,    99,    98,    98,
      98,    98,    98,    31,   101,     5,    83,    85,    86,    97,
       5,    96,    98,    24,    44,    88,    86,    86,     5,    97,
      89,     5,    97,     5,    84,    98,   103,     5,    98,     5,
       5,    98,     5,    98,    98,    98,    98,     5,    13,   111,
     109,     5,    95,    97,    97,    97,   105,   106,    68,    98,
      24,    68,    95,    98,    98,    98,    98,     6,    47,    90,
       7,    82,    86,    97,    82,    86,     5,    97,     5,    98,
       5,     5,    89,   100,   105,    98,    98,    97,    98,    98,
      98,    24,   110,    97,   100,     6,    68,    69,    76,    77,
      95,   100,     5,   106,   106,     5,     5,     7,    98,    97,
       5,     7,    48,    49,    51,    78,    92,    97,     6,    95,
      98,    95,    98,    95,    97,    90,     5,    86,    97,    86,
      97,     5,    98,    98,    91,    98,    95,    98,    95,     5,
       5,     8,    98,   102,    97,     5,     5,   100,     5,     5,
     102,    97,     5,    24,   104,    92,    97,    97,    92,    92,
      48,    49,    51,    52,    79,    93,    97,    95,    93,    95,
      93,    90,    42,    95,   100,   100,    95,    48,    63,    87,
     102,   102,     5,    97,     5,     5,     5,   104,   102,    92,
      93,    97,    97,    97,    93,    93,    93,    48,    49,    51,
      52,    80,    94,    97,    43,     5,     5,    49,    81,     5,
      87,     5,     5,    97,    93,    93,    94,    97,    97,    97,
      94,    94,     5,    97,     5,     5,    97,    94,    94,    97,
      97,    97,    97
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 6:

/* Line 1455 of yacc.c  */
#line 183 "parse_spice.y"
    {
    /* chain definition root */
    (yyvsp[(1) - (1)].definition)->next = definition_root;
    definition_root = (yyvsp[(1) - (1)].definition);
  }
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 188 "parse_spice.y"
    {
    /* chain definition root */
    if ((yyvsp[(1) - (1)].definition)) {
      (yyvsp[(1) - (1)].definition)->next = definition_root;
      definition_root = (yyvsp[(1) - (1)].definition);
    }
  }
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 195 "parse_spice.y"
    { /* nothing to do here */ }
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 196 "parse_spice.y"
    { /* nothing to do here */ }
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 200 "parse_spice.y"
    {
    /* R, L and C definitions */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 208 "parse_spice.y"
    {
    /* R, L and C definitions specified by a Model */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 217 "parse_spice.y"
    {
    /* R, L and C definitions specified by a Model, a variant */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
  }
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 225 "parse_spice.y"
    {
    /* R definitions specified by a Model, yet another variant */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 233 "parse_spice.y"
    {
    /* R definitions including TC1 */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 241 "parse_spice.y"
    {
    /* R definitions including TC1/TC2 */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 249 "parse_spice.y"
    {
    /* non-linear C and L poly definitions */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 258 "parse_spice.y"
    {
    /* Mutual inductors */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (5)].ident), HINT_NUMBER);
  }
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 265 "parse_spice.y"
    {
    /* independent current/voltage sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 272 "parse_spice.y"
    {
    /* independent current/voltage sources given the value */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 280 "parse_spice.y"
    {
    /* voltage controlled source POLY */
    if (!_stricmp ((yyvsp[(4) - (7)].ident), "POLY")) {
      (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
      spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NAME);
      spice_append_val_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NUMBER);
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
    }
    else {
      fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (7)].ident));
      (yyval.definition) = NULL;
    }
  }
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 295 "parse_spice.y"
    {
    /* voltage controlled sources OTHER behavioural */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (5)].ident));
    (yyval.definition) = NULL;
  }
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 300 "parse_spice.y"
    {
    /* voltage controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NUMBER);
  }
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 309 "parse_spice.y"
    {
    /* current controlled source POLY */
    if (!_stricmp ((yyvsp[(4) - (8)].ident), "POLY")) {
      (yyval.definition) = spice_create_device ((yyvsp[(1) - (8)].ident));
      spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NAME);
      spice_append_val_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NUMBER);
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (8)].value));
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (8)].value));
    }
    else {
      fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (8)].ident));
      (yyval.definition) = NULL;
    }
  }
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 325 "parse_spice.y"
    {
    /* current controlled sources OTHER behavioural */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (5)].ident));
    (yyval.definition) = NULL;
  }
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 330 "parse_spice.y"
    {
    /* current controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NUMBER);
  }
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 338 "parse_spice.y"
    {
    /* device specification */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (5)].ident), (yyvsp[(2) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[(4) - (5)].value), HINT_MSTOP);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 345 "parse_spice.y"
    {
    /* diode */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (5)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (5)].value));
  }
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 353 "parse_spice.y"
    {
    /* JFET */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 362 "parse_spice.y"
    {
    /* 3 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 371 "parse_spice.y"
    {
    /* 4 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (7)].value));
  }
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 381 "parse_spice.y"
    {
    /* MOS */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (7)].value));
  }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 391 "parse_spice.y"
    {
    /* MES */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 400 "parse_spice.y"
    {
    /* transient analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 405 "parse_spice.y"
    {
    /* plotting */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), _strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(3) - (4)].value));
  }
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 411 "parse_spice.y"
    {
    /* AC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 416 "parse_spice.y"
    {
    /* single DC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 420 "parse_spice.y"
    {
    /* DC analysis first order */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 425 "parse_spice.y"
    {
    /* DC analysis second order */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), _strdup ((yyvsp[(1) - (4)].ident)));
    (yyval.definition)->values = netlist_append_values ((yyvsp[(2) - (4)].value), (yyvsp[(3) - (4)].value));
  }
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 430 "parse_spice.y"
    {
    /* printing specifying the analysis type */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), _strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(3) - (4)].value));
  }
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 436 "parse_spice.y"
    {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 441 "parse_spice.y"
    {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), _strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (4)].ident), HINT_NAME);
  }
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 447 "parse_spice.y"
    {
    /* general analysis options */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 452 "parse_spice.y"
    {
    /* temperatur analysis (Spice 2g6) */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 457 "parse_spice.y"
    {
    /* TODO: default width of ??? */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 462 "parse_spice.y"
    {
    /* noise analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (5)].ident), _strdup ((yyvsp[(1) - (5)].ident)));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(2) - (5)].value));
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 469 "parse_spice.y"
    {
    /* pole-zero analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (8)].ident), _strdup ((yyvsp[(1) - (8)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (8)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(7) - (8)].ident), HINT_NAME);
  }
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 479 "parse_spice.y"
    {
    /* subcircuit call */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (3)].ident));
    spice_set_last_hint ((yyvsp[(2) - (3)].value), HINT_NAME);
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 485 "parse_spice.y"
    {
    /* voltage controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (8)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (8)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (8)].value));
  }
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 495 "parse_spice.y"
    {
    /* current controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 504 "parse_spice.y"
    {
    /* lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
  }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 513 "parse_spice.y"
    {
    /* distributed lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 522 "parse_spice.y"
    {
    /* lossless transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 531 "parse_spice.y"
    {
    /* lossless transline and initial condition */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (8)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (8)].value));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (8)].value));
  }
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 541 "parse_spice.y"
    {
    /* operating point analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 545 "parse_spice.y"
    {
    /* saving action */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 549 "parse_spice.y"
    {
    /* sensitivity analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 553 "parse_spice.y"
    {
    /* transfer function analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 557 "parse_spice.y"
    {
    /* fourier analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), _strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 561 "parse_spice.y"
    {
    /* non-linear dependent sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (2)].ident));
  }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 565 "parse_spice.y"
    {
    /* distortion analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 570 "parse_spice.y"
    {
    /* file include */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    struct value_t * file = create_value ();
    file->ident = (yyvsp[(2) - (3)].ident);
    file->hint = HINT_NAME;
    (yyval.definition)->values = file;
  }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 578 "parse_spice.y"
    {
    /* nodeset functionality */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), _strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 586 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (2)].ident), (yyvsp[(2) - (2)].ident));
  }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 593 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NUMBER);
  }
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 601 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NUMBER);
  }
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 609 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (3)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (3)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NUMBER);
  }
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 617 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (4)].ident), HINT_NUMBER);
  }
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 627 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (5)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(5) - (5)].ident), HINT_NUMBER);
  }
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 638 "parse_spice.y"
    { /* range specification during plotting */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NUMBER);
  }
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 646 "parse_spice.y"
    { // TODO: 2 reduce/reduce, 2 shift/reduce
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), _strdup ("V"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NODE | HINT_MSTOP);
  }
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 652 "parse_spice.y"
    { // TODO: 2 reduce/reduce
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NODE | HINT_MSTOP);
  }
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 658 "parse_spice.y"
    {
    /* print/plot specification of differential node voltages */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (3)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (3)].ident), HINT_NODE);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NODE | HINT_MSTOP);    
  }
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 671 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 677 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), _strdup ("I"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 683 "parse_spice.y"
    {
    /* print/plot specification of operating point */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), _strdup ("OP"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 691 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 692 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 695 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (3)].value), (yyvsp[(2) - (3)].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 81:

/* Line 1455 of yacc.c  */
#line 699 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 702 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (3)].value), (yyvsp[(2) - (3)].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 708 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 709 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (1)].ident), HINT_NAME);
  }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 712 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (1)].ident), HINT_NAME);
  }
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 717 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 718 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 721 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 726 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 727 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 731 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 737 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 738 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 742 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 748 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 749 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NODE | HINT_MSTOP);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(4) - (4)].value));
  }
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 758 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 759 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 763 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value (_strdup ("Area"), (yyvsp[(1) - (2)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 767 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 771 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 776 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 777 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 781 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value (_strdup ("Area"), (yyvsp[(1) - (2)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 785 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 789 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 792 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 798 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 799 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 803 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 807 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 811 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 815 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 823 "parse_spice.y"
    {
    /* identification of a DC sweep */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (4)].ident), HINT_NUMBER | HINT_MSTOP);
  }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 839 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 840 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value)->next = (yyvsp[(3) - (3)].value);
  }
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 846 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 847 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 853 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 854 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 858 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 864 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 865 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 871 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 872 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 879 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[(2) - (2)].value), HINT_MSTOP);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 886 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 887 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 893 "parse_spice.y"
    {
    (yyvsp[(1) - (3)].definition)->sub = (yyvsp[(2) - (3)].definition);
    (yyval.definition) = (yyvsp[(1) - (3)].definition);
    (yyvsp[(2) - (3)].definition) = NULL;
  }
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 901 "parse_spice.y"
    {
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), (yyvsp[(2) - (4)].ident));
    (yyval.definition)->values = (yyvsp[(3) - (4)].value);
  }
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 907 "parse_spice.y"
    { (yyval.definition) = NULL; }
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 908 "parse_spice.y"
    { /* chain definitions here */
    if ((yyvsp[(1) - (2)].definition)) {
      (yyvsp[(1) - (2)].definition)->next = (yyvsp[(2) - (2)].definition);
      (yyval.definition) = (yyvsp[(1) - (2)].definition);
    }
    else {
      (yyval.definition) = (yyvsp[(2) - (2)].definition);
    }
  }
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 922 "parse_spice.y"
    { /* nothing to do */ }
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 923 "parse_spice.y"
    { free ((yyvsp[(2) - (2)].ident)); /* nothing to do */ }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 927 "parse_spice.y"
    { /* chain definitions here */
    if ((yyvsp[(1) - (1)].definition)) {
      (yyvsp[(1) - (1)].definition)->next = (yyval.definition);
      (yyval.definition) = (yyvsp[(1) - (1)].definition);
    }
  }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 933 "parse_spice.y"
    { /* do nothing here, see subcircuit rule */ }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 934 "parse_spice.y"
    {
    (yyval.definition) = NULL;
  }
    break;



/* Line 1455 of yacc.c  */
#line 3333 "parse_spice.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 939 "parse_spice.y"


int spice_error (const char * error) {
  fprintf (stderr, "line %d: %s\n", spice_lineno, error);
  return 0;
}

