/* -*-c-*- */

%{
/*
 * scan_zvr.l - scanner for a ZVR data file
 *
 * Copyright (C) 2006, 2007 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: scan_zvr.l,v 1.2 2007/04/11 17:57:19 ela Exp $
 *
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef __MINGW32__
#include <io.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "check_zvr.h"
#include "tokens_zvr.h"

#if !HAVE_STRCHR
# define strchr  index
# define strrchr rindex
#endif

%}

WS       [ \t\n\r]
DIGIT    [0-9]
EXPONENT [Ee][+-]?{DIGIT}+
INT      [+-]?{DIGIT}+
REAL     [+-]?{DIGIT}+("."{DIGIT}+)?{EXPONENT}?
DECIMAL  {DIGIT}+
IDENT    [a-zA-Z][a-zA-Z-]*
DIGITS   {DIGIT}+
DIDENT   [A-Z]({DIGIT}{1,2})?

%x VERSION

%option yylineno noyywrap nounput prefix="zvr_"

%%

<INITIAL>"ZVR," {
  BEGIN(VERSION);
  return ZVR;
}

<VERSION>{DIGITS}"."{DIGITS} {
  BEGIN(INITIAL);
  return Version;
}

<INITIAL>{REAL} {
  zvr_lval.f = strtod (zvr_text, NULL);
  return Real;
}

<INITIAL>("Hz")|("none")|("dB") {
  zvr_lval.ident = strdup (zvr_text);
  return Unit;
}

<INITIAL>("RI")|("COMPLEX")|("MAGNITUDE")|("PHASE")|("MA")|("DB") {
  zvr_lval.ident = strdup (zvr_text);
  return DataFMT;
}

<INITIAL>{DIDENT} {
  zvr_lval.ident = strdup (zvr_text);
  return DataTYP;
}

<INITIAL>{IDENT} {
  zvr_lval.ident = strdup (zvr_text);
  return Identifier;
}

<INITIAL>(("re")|("im")|("mag")|("ang")|("db"))?{DIDENT} {
  zvr_lval.ident = strdup (zvr_text);
  return DataIDN;
}

<INITIAL>";"   { /* pass the ';' to the parser */ return ';'; }

<*>\r?\n|{WS}  { /* skip end of line and spaces */ }

<*>. { /* any other character is invalid */
  fprintf (stderr, 
	   "line %d: syntax error, unrecognized character: `%s'\n", 
	   zvr_lineno, zvr_text);
  return InvalidCharacter;
}

%%
