/***************************************************************************
                               qf_comp.cpp
                              -------------
    begin                : Fri May 1 2009
    copyright            : (C) 2009 by Vincent Habchi, F5RCS
    email                : 10.50@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include "qf_common.h"
#include "qf_comp.h"
#include "filter.h"

void qf_cmp1::dump (unsigned, unsigned n2,
		    QTextStream& com, QTextStream& wir) {

  // type of component
  if (name == "CAP")
    com << "C C1";
  else if (name == "IND")
    com << "L L1";

  // single component to ground
  if (n2 == 0) {
    // wire
    wir << x << " " << y-30 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
    // position
    com << " 1 " << x << " " << y << " 17 -26 0 1";
    // value of component
    com << " \"" << num2str (val) << unit << "\" 1\n";
    // place ground symbol here
    com << "GND * 1 " << x << " " << y+30 << " 0 0 0 0\n";
  }
  // single component in series
  else {
    // wires
    wir << x << " " << y-80 << " " << x+40 << " " << y-80 << " \"\" 0 0 0\n";
    wir << x+100 << " " << y-80 << " " << x+140 << " " << y-80 << " \"\" 0 0 0\n";
    // position
    com << " 1 " << x+70 << " " << y-80 << " -26 10 0 0";
    // value of commponent
    com << " \"" << num2str (val) << unit << "\" 1\n";
    x += 140;
  }
}

void qf_cmplc::dump (unsigned, unsigned n2,
		     QTextStream& com, QTextStream& wir) {

  if (name == "PLC") {
    // parallel L and C to ground
    if (n2 == 0) {
      // wire
      wir << x << " " << y-30 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
      // inductor
      com << "L L1";
      // position
      com << " 1 " << x << " " << y << " 17 -26 0 1";
      // value of component
      com << " \"" << num2str (vL) << "H\" 1\n";
      // place ground symbol here
      com << "GND * 1 " << x << " " << y+30 << " 0 0 0 0\n";

      // connecting above wire
      wir << x << " " << y-80 << " " << x+110 << " " << y-80 << " \"\" 0 0 0\n";

      x += 110;

      // wire
      wir << x << " " << y-30 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
      // capacitor
      com << "C C1";
      // position
      com << " 1 " << x << " " << y << " 17 -26 0 1";
      // value of component
      com << " \"" << num2str (vC) << "F\" 1\n";
      // place ground symbol here
      com << "GND * 1 " << x << " " << y+30 << " 0 0 0 0\n";
    }
    // parallel L and C in series
    else {
      // wires
      wir << x << " " << y-80 << " " << x+40 << " " << y-80 << " \"\" 0 0 0\n";
      wir << x+100 << " " << y-80 << " " << x+140 << " " << y-80 << " \"\" 0 0 0\n";
      // inductor
      com << "L L1";
      // position
      com << " 1 " << x+70 << " " << y-80 << " -26 10 0 0";
      // value of commponent
      com << " \"" << num2str (vL) << "H\" 1\n";

      // wires
      wir << x+40 << " " << y-80 << " " << x+40 << " " << y-120 << " \"\" 0 0 0\n";
      wir << x+100 << " " << y-80 << " " << x+100 << " " << y-120 << " \"\" 0 0 0\n";
      // capacitor
      com << "C C1";
      // position
      com << " 1 " << x+70 << " " << y-120 << " -26 -48 0 0";
      // value of commponent
      com << " \"" << num2str (vC) << "F\" 1\n";

      x += 140;
    }
  }
  else if (name == "SLC") {
    // series L and C to ground
    if (n2 == 0) {
      // wire
      wir << x << " " << y-60 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
      // inductor
      com << "L L1";
      // position
      com << " 1 " << x << " " << y-30 << " 17 -26 0 1";
      // value of component
      com << " \"" << num2str (vL) << "H\" 1\n";

      // capacitor
      com << "C C1";
      // position
      com << " 1 " << x << " " << y+30 << " 17 -26 0 1";
      // value of component
      com << " \"" << num2str (vC) << "F\" 1\n";
      // place ground symbol here
      com << "GND * 1 " << x << " " << y+60 << " 0 0 0 0\n";

      // wire
      wir << x << " " << y-80 << " " << x+100 << " " << y-80 << " \"\" 0 0 0\n";
      x += 100;
    }
    // series L and C in series
    else {
      // wires
      wir << x+60 << " " << y-80 << " " << x+80 << " " << y-80 << " \"\" 0 0 0\n";
      wir << x+140 << " " << y-80 << " " << x+180 << " " << y-80 << " \"\" 0 0 0\n";
      // inductor
      com << "L L1";
      // position
      com << " 1 " << x+30 << " " << y-80 << " -26 10 0 0";
      // value of commponent
      com << " \"" << num2str (vL) << "H\" 1\n";

      // capacitor
      com << "C C1";
      // position
      com << " 1 " << x+110 << " " << y-80 << " -26 10 0 0";
      // value of commponent
      com << " \"" << num2str (vC) << "F\" 1\n";

      x += 180;
    }
  }
}

void  qf_pslc::dump (unsigned n1, unsigned n2,
		     QTextStream& s, QTextStream& wir) {
  qf_slc component1(vC, vL, shnt, gnd);
  qf_slc component2(vC2, vL2, shnt, gnd);

  component1.x = x;
  component1.y = y;
  component1.dump (n1, n2, s, wir);
  x = component1.x;
  y = component1.y;

  component2.x = x;
  component2.y = y;
  component2. dump (n1, n2, s, wir);
  x = component2.x;
  y = component2.y;
}

// Dumps the whole filter structure
int qf_lcmp::dump_node (int& p, list <qf_cmp*>::iterator& i,
			  QTextStream& com, QTextStream& wir) {

  int n = p + 1;
  int g = 0;

  if ((*i) -> name == "END") return -n;		  // End of structure
  while (i != lst. end ()) {

    if ((*i) == NULL) return 0;
    if ((*i) -> name == "END") return -n;	  // End of structure

    if ((*i) -> gnd) {
      if (g) {
        // connecting wire for consecutive branches to ground
        wir << x << " " << y-80 << " " << x+110 << " " << y-80 << " \"\" 0 0 0\n";
        x += 110;
      }
      (*i) -> x = x;
      (*i) -> y = y;
      (*i) -> dump (p, 0, com, wir);
      x = (*i) -> x;
      y = (*i) -> y;
      g = 1;
      i ++;
      continue;
    }

    g = 0;
    (*i) -> x = x;
    (*i) -> y = y;
    (*i) -> dump (p, n, com, wir);
    x = (*i) -> x;
    y = (*i) -> y;
    if ((*i) -> shnt) {
      i ++;
      n = dump_node (n, i, com, wir);
    }
    else {
      i ++;
      return n;
    }
  } 
  return -n;
}

void qf_lcmp::dump_all (QTextStream& out) {

  if (lst.size () == 0) {
    return;
  }

  int node = 1;
  QString buf1, buf2;
  QTextStream com (&buf1, QIODevice::ReadWrite);
  QTextStream wir (&buf2, QIODevice::ReadWrite);

  x = 0;
  y = 0;

  // schematic start
  out << QUCSFILE_ID << PACKAGE_VERSION << ">\n";

  // input port and according ground symbol
  com << "Pac P1 1 " << x << " " << y << " 18 -26 0 0 \"1\" 1 \""
      << r1 << "\" 1\n";
  com << "GND * 1 " << x << " " << y+30 << " 0 0 0 0\n";
  wir << x << " " << y-30 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
  wir << x << " " << y-80 << " " << x+110 << " " << y-80 << " \"\" 0 0 0\n";

  x += 110;
  for (list <qf_cmp*>::iterator i = lst. begin (); i != lst. end ();) 
    if ((node = dump_node (node, i, com, wir)) < 0) break;

  // output port and according ground symbol
  x += 110;
  wir << x << " " << y-30 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
  wir << x-110 << " " << y-80 << " " << x << " " << y-80 << " \"\" 0 0 0\n";
  com << "Pac P2 1 "<< x << " " << y << " 18 -26 0 0 \"2\" 1 \""
      << r2 << "\" 1 \"0\" 0\n"
      << "GND * 1 " << x << " " << y+30 << " 0 0 0 0\n";

  x = 0;

  // S-parameter simulation box and equation
  com << ".SP SP1 1 " << x << " " << y+90 << " 0 60 0 0 \"log\" 1 \""
      << num2str(fc/2/M_PI/10) << "Hz\" 1 \"" << num2str(fc/2/M_PI*10)
      << "Hz\" 1 \"600\" 1 \"no\" 0 \"1\" 0 \"2\" 0\n";
  com << "Eqn Eqn1 1 " << x+170 << " " << y+107
      << " 0 8 0 0 \"S21_dB=dB(S[2,1])\" 1 \"S11_dB=dB(S[1,1])\" 1 \"yes\" 0\n";

  // components
  out << "<Components>\n";
  out << buf1;
  out << "</Components>\n";
  // wires
  out << "<Wires>\n";
  out << buf2;
  out << "</Wires>\n";
  // paintings
  out << "<Paintings>\n";
  out << "Text " << x+340 << " " << y+90 << " 12 #000000 0 \""
      << tx << " \\n "
      << num2str(fc/2/M_PI) << "Hz cutoff/center frequency \\n "
      << "impedance matching Z_{IN}=" << num2str(r1) << "\\Omega, Z_{OUT}="
      << num2str(r2) << "\\Omega\"\n";
  out << "</Paintings>\n";
}

// Access to the list of components

void	qf_lcmp::init (void) {

  iter = lst. begin ();
}

qf_cmp*	qf_lcmp::next (void) {

  qf_cmp* cmp = * iter;

  if ((cmp == NULL) || (cmp->name == "END")) return NULL;
  iter ++;
  return cmp;
}
