/***************************************************************************
    copyright: (C) 2005 by Michael Margraf
 ***************************************************************************/

#ifndef QUCSFILTER_H
#define QUCSFILTER_H

#include <QDialog>

class QDir;
class QLabel;
class QGroupBox;
class QCheckBox;
class QComboBox;
class QLineEdit;
class QRadioButton;

class QuantityBox;
class UnitComboBox;


class QucsFilter : public QDialog
{
  Q_OBJECT
public:
  QucsFilter();

  bool loadSettings(QDir*);
  bool saveApplSettings(QDir*);

public slots:
  void slotTypeChanged(int);
  void slotClassChanged(int);
  void slotRealizationChanged(int);

private slots:
  void slotHelpIntro();
  void slotHelpAbout();
  void slotHelpAboutQt();
  void slotCalculate();
  void slotShowResult();
  void slotSetMicrostrip(int);

private:
  void setError(const QString&);
  QByteArray calculateFilter(struct tFilter*);

  int ResultState;

  QGroupBox *boxSubstrate, *boxTopology;
  QLabel *LabelRipple, *LabelRipple_dB, *LabelStart, *LabelStop, *LabelResult,
         *LabelBandStop, *LabelOrder, *LabelOhm, *LabelImpedance,
         *LabelMin, *LabelMax, *LabelMinUnit, *LabelMaxUnit;

  QCheckBox *checkMicrostrip;
  QRadioButton *radioPi, *radioTee;
  QLineEdit *EditOrder, *EditCorner, *EditStop, *EditRipple, *EditImpedance,
            *EditBandStop, *EditThickness, *EditHeight, *EditMinWidth,
            *EditMaxWidth;
  QComboBox *ComboRealize, *ComboType, *ComboClass;
  UnitComboBox *ComboCorner, *ComboStop, *ComboBandStop, *ComboHeight, *ComboThickness;
  QuantityBox *ComboEr;
};

#endif
