/***************************************************************************
    copyright: (C) 2005 by Michael Margraf
 ***************************************************************************/

#include "config.h"
#include "mywidgets.h"
#include "qucsfilter.h"

#include <stdlib.h>

#include <QDir>
#include <QString>
#include <QTranslator>
#include <QTextStream>
#include <QApplication>

// -----------------------------------------------------------------------
int main(int argc, char *argv[])
{
  QString lang;
  QApplication a(argc, argv);

  // Home directory can be set per command line argument.
  QString s = QDir::homePath() + "/.qucs";
  QStringList arg = a.arguments();
  for(int z=1; z<arg.size(); z++)
    if(arg.at(z).at(0) == '-') {
      s = arg.at(z).mid(1);
      break;
    }
  QDir QucsHomeDir(s);

  // load language setting
  QFile file(QucsHomeDir.absoluteFilePath("qucsrc"));
  if(file.open(QIODevice::ReadOnly)) {
    QString Line, Setting;
    QTextStream stream(&file);
    while(!stream.atEnd()) {
      Line = stream.readLine();
      Setting = Line.section('=',0,0);
      if(Setting == "Language")
        lang = Line.section('=',1,1).trimmed();
    }
    file.close();
  }

  QTranslator tor(0);
  if(lang.isEmpty())
    lang = QLocale::system().name();
  tor.load(QString("qucs_") + lang, a.applicationDirPath());
  a.installTranslator(&tor);

  QucsFilter *qucs = new QucsFilter;
  qucs->loadSettings(&QucsHomeDir);
  qucs->show();
  int result = a.exec();
  qucs->saveApplSettings(&QucsHomeDir);
  return result;
}
