/***************************************************************************
  copyright: (C) 2016 by Michael Margraf
 ***************************************************************************/

#ifndef MYWIDGETS_H
#define MYWIDGETS_H

#include <QComboBox>
#include <QDoubleValidator>

class QLineEdit;

extern const char *List_er[];
extern const char *List_rho[];
extern const char *List_tand[];
extern const char *List_murC[];
extern const char **List_Properties[];

// .....................................................
#define QUANTITY_LENGTH     0
#define QUANTITY_FREQUENCY  1

class UnitComboBox : public QComboBox {
  Q_OBJECT
public:
  UnitComboBox(int quantity_ = QUANTITY_LENGTH, int index=3);
  bool isMetric();
  QString string(QLineEdit*);
  double value(QLineEdit*);
  void setValue(double, QLineEdit*);

private:
  int quantity;
};


// .....................................................
typedef const char**  ppChar;

class QuantityBox : public QComboBox {
  Q_OBJECT
public:
  QuantityBox(ppChar, QWidget *parent=0);

private slots:
  void slotSetIndex();

private:
  QDoubleValidator dblVal;
};

#endif
