/***************************************************************************
  copyright: (C) 2010 by Michael Margraf
 ***************************************************************************/

#ifndef FILTER_H
#define FILTER_H

#define CLASS_LOWPASS    0
#define CLASS_HIGHPASS   1
#define CLASS_BANDPASS   2
#define CLASS_BANDSTOP   3
#define CLASS_DIPLEXER   4
#define CLASS_TRIPLEXER  5

#define TYPE_BESSEL         0
#define TYPE_BUTTERWORTH    1
#define TYPE_LEGENDRE       2
#define TYPE_CHEBYSHEV      3
#define TYPE_INV_CHEBYSHEV  4
#define TYPE_CAUER          5

#define M_TWO_PI   6.28318530717958647693
#define LIGHTSPEED 299792458.0
#define EPSILON0   8.854187817e-12
#define Z_FIELD    376.73031346958504364963

#include <math.h>

double atanh (const double x);
double asinh (const double x);
double acosh (const double x);
double coth (const double x);
double sech (const double x);

struct tFilter {
  int Type;
  int Class;
  int Order;
  bool piType;
  double Ripple;
  double Impedance;
  double Frequency;
  double Frequency2;
  double Frequency3;
  double Zhigh, Zlow;
};


class QString;
class QByteArray;

QString num2str(double Num, const char *unit=0);
double getE6value(double);

class Filter {
public:
  Filter() {};

  static double* getNormValues(tFilter*);
  static double getQuadraticNormValues(int, tFilter*, double&);
  static QString getDescription(tFilter*);

private:
  static double* BesselValue(int);
  static double* ButterworthValue(int);
  static double* LegendreValue(int);
  static double* ChebyshevValue(int, double);

  static double quadraticBesselValues(int, int, double&);
  static double quadraticButterworthValues(int, int, double&);
  static double quadraticChebyshevValues(int, int, double, double&);
};

#endif
