// Headers for legendre filters
#ifndef _QF_LGNDR_H
#define	_QF_LGNDR_H

class qf_lgndr : public qf_filter {
  private:

    qf_double_t	    ws;			// Normalisation factor

    qf_poly	    legendre  (void);	// Computes Legendre's polynom
    bool	    synth     (void);

  friend qf_filter* lgndr     (qf_spec* Pspec) {return new qf_lgndr (Pspec);}

public:
  qf_lgndr(qf_spec*);
  void norm_values(double*);
};

qf_filter*	    lgndr     (qf_spec*);

  # ifdef _QF_API
struct	qf_filter_api	    qf_lgndr_api = {
	"Legendre",
	lgndr
};

  # endif // _QF_API
# endif	  // _QF_LGNDR_H
